/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Arrays;
import java.util.Collection;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.query.Where;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyTreeMap;

public class Conditions {
    public final KeyTreeMap<Condition> map = new KeyTreeMap(Condition.keyDefinitions());

    public Conditions() {
    }

    public Conditions(Collection<Condition> conditions) {
        for (Condition condition : conditions) {
            this.add(condition);
        }
    }

    public void add(Condition condition) {
        this.map.put(condition);
    }

    public Conditions(Condition ... conditions) {
        this(Arrays.asList(conditions));
    }

    public Where<ConditionSelector, ConditionListen> where(final Matcher matcher) {
        return new Where<ConditionSelector, ConditionListen>(){

            @Override
            public ConditionSelector select() {
                return new ConditionSelector(matcher);
            }

            @Override
            public ConditionListen listen() {
                return new ConditionListen(matcher);
            }
        };
    }

    public void merge(Conditions conditions) {
        this.map.merge(conditions.map);
    }

    public void remove(Column column) {
        ExactMatcher matcher = Condition.columnUUID().is(column.getUuidKey());
        for (Condition condition : this.where(matcher).select().all()) {
            condition.getUuidKey().retract();
        }
    }

    public class ConditionSelector
    extends Select<Condition> {
        public ConditionSelector(Matcher matcher) {
            super(Conditions.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class ConditionListen
    extends Listen<Condition> {
        public ConditionListen(Matcher matcher) {
            super(Conditions.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }
}

