/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.IndexKey;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UpdatableKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.query.Matchers;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.util.HasIndex;
import org.drools.verifier.core.maps.util.HasKeys;

public class Column
implements HasKeys,
HasIndex {
    private final UUIDKey uuidKey;
    private UpdatableKey<Column> indexKey;

    public Column(int columnIndex, AnalyzerConfiguration configuration) {
        this.indexKey = new UpdatableKey(IndexKey.INDEX_ID, Integer.valueOf(columnIndex));
        this.uuidKey = configuration.getUUID(this);
    }

    public static Matchers index() {
        return new Matchers(IndexKey.INDEX_ID);
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, IndexKey.INDEX_ID};
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, this.indexKey};
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public int getIndex() {
        return (Integer)this.indexKey.getSingleValueComparator();
    }

    @Override
    public void setIndex(int index) {
        if (this.indexKey.getSingleValue().equals(new Value(Integer.valueOf(index)))) {
            return;
        }
        UpdatableKey<Column> oldKey = this.indexKey;
        UpdatableKey newKey = new UpdatableKey(IndexKey.INDEX_ID, Integer.valueOf(index));
        this.indexKey = newKey;
        oldKey.update(newKey, this);
    }
}

