/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.HashSet;
import java.util.List;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.OneToManyCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;

public class DetectDeficientRowsCheck
extends OneToManyCheck {
    public DetectDeficientRowsCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, other -> !ruleInspector.getRule().getUuidKey().equals(other.getRule().getUuidKey()) && !other.isEmpty(), configuration, CheckType.DEFICIENT_ROW);
    }

    @Override
    public boolean check() {
        this.hasIssues = !this.ruleInspector.isEmpty() && this.ruleInspector.atLeastOneConditionHasAValue() && this.thereIsAtLeastOneRow() && this.isDeficient();
        return this.hasIssues;
    }

    private boolean isDeficient() {
        return !this.getOtherRows().stream().anyMatch(other -> !this.isDeficient((RuleInspector)other));
    }

    private boolean isDeficient(RuleInspector other) {
        return this.ruleInspector.isDeficient(other);
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(List.of(Integer.valueOf(this.ruleInspector.getRowIndex() + 1))));
    }
}

