/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.relations;

import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.Relation;
import org.drools.verifier.core.relations.SubsumptionResolver;
import org.drools.verifier.core.util.PortablePreconditions;

public class SubsumptionBlocker
extends Relation<SubsumptionBlocker> {
    public static final SubsumptionBlocker EMPTY = new SubsumptionBlocker();
    private final InspectorList list;
    private final HasUUID item;

    private SubsumptionBlocker() {
        super(null);
        this.list = null;
        this.item = null;
    }

    public SubsumptionBlocker(InspectorList list, HasUUID item) {
        super(null);
        this.list = PortablePreconditions.checkNotNull("list", list);
        this.item = PortablePreconditions.checkNotNull("item", item);
    }

    public SubsumptionBlocker(InspectorList list, HasUUID item, SubsumptionBlocker origin) {
        super(origin);
        this.list = PortablePreconditions.checkNotNull("list", list);
        this.item = PortablePreconditions.checkNotNull("item", item);
    }

    private HasUUID getItem() {
        return this.item;
    }

    private InspectorList getList() {
        return this.list;
    }

    @Override
    public boolean foundIssue() {
        return this.item != null;
    }

    @Override
    public UUIDKey otherUUID() {
        return this.item.getUuidKey();
    }

    @Override
    public boolean doesRelationStillExist() {
        if (this.origin != null && this.stillContainsBlockingItem(((SubsumptionBlocker)this.getOrigin()).getItem())) {
            return SubsumptionResolver.isSubsumedByAnObjectInThisList(((SubsumptionBlocker)this.getOrigin()).getList(), ((SubsumptionBlocker)this.getOrigin()).getItem()).foundIssue();
        }
        return false;
    }

    private boolean stillContainsBlockingItem(HasUUID item) {
        if (this.item instanceof InspectorList) {
            return ((InspectorList)this.item).contains(item);
        }
        if (this.parent != null) {
            return ((SubsumptionBlocker)this.parent).stillContainsBlockingItem(item);
        }
        return false;
    }
}

