/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.SingleRangeCheck;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.CheckFactory;
import org.drools.verifier.core.checks.base.CheckStorage;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.matchers.UUIDMatcher;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.index.model.Fields;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.util.PortablePreconditions;

public class RuleInspectorCache {
    private final Map<Rule, RuleInspector> ruleInspectors = new HashMap<Rule, RuleInspector>();
    private final Set<Check> generalChecks = new HashSet<Check>();
    protected final Index index;
    private final CheckStorage checkStorage;
    private final AnalyzerConfiguration configuration;

    public RuleInspectorCache(Index index, AnalyzerConfiguration configuration) {
        this.index = PortablePreconditions.checkNotNull("index", index);
        this.checkStorage = new CheckStorage(new CheckFactory(PortablePreconditions.checkNotNull("configuration", configuration)));
        this.configuration = configuration;
    }

    public void reset() {
        for (RuleInspector ruleInspector : this.ruleInspectors.values()) {
            ruleInspector.clearChecks();
        }
        this.ruleInspectors.clear();
        this.generalChecks.clear();
        for (Rule rule : this.index.getRules().where(Rule.uuid().any()).select().all()) {
            this.add(new RuleInspector(rule, this.checkStorage, this, this.configuration));
        }
        this.generalChecks.add(new SingleRangeCheck(this.configuration, this.ruleInspectors.values()));
    }

    public Set<Check> getGeneralChecks() {
        return this.generalChecks;
    }

    public void newColumn(Column column) {
        this.index.getColumns().add(column);
    }

    public Collection<RuleInspector> all() {
        return this.ruleInspectors.values();
    }

    public Set<Issue> getAllIssues() {
        HashSet<Issue> issues = new HashSet<Issue>();
        issues.addAll(this.all().stream().flatMap(inspector -> inspector.getChecks().stream()).filter(Check::hasIssues).map(Check::getIssue).collect(Collectors.toSet()));
        issues.addAll(this.generalChecks.stream().filter(Check::hasIssues).map(Check::getIssue).collect(Collectors.toSet()));
        return issues;
    }

    public Collection<RuleInspector> all(Predicate<RuleInspector> filter) {
        return this.all().stream().filter(filter).collect(Collectors.toList());
    }

    private void add(RuleInspector ruleInspector) {
        this.ruleInspectors.put(ruleInspector.getRule(), ruleInspector);
    }

    public RuleInspector removeRow(int rowNumber) {
        Rule rule = this.getRule(rowNumber);
        RuleInspector remove = this.ruleInspectors.remove(rule);
        this.index.getRules().remove(rule);
        return remove;
    }

    private Rule getRule(int rowNumber) {
        return (Rule)this.index.getRules().where(Rule.index().is(Integer.valueOf(rowNumber))).select().first();
    }

    public void deleteColumns(int firstColumnIndex) {
        Collection all = this.index.getColumns().where(Column.index().is(Integer.valueOf(firstColumnIndex))).select().all();
        Fields.FieldSelector fieldSelector = this.index.getRules().where(UUIDMatcher.uuid().any()).select().patterns().where(UUIDMatcher.uuid().any()).select().fields().where(UUIDMatcher.uuid().any()).select();
        ArrayList actions = new ArrayList();
        ArrayList conditions = new ArrayList();
        for (Field field : fieldSelector.all()) {
            for (Column column : all) {
                Collection all1 = field.getActions().where(Action.columnUUID().is(column.getUuidKey())).select().all();
                Collection all2 = field.getConditions().where(Condition.columnUUID().is(column.getUuidKey())).select().all();
                actions.addAll(all1);
                conditions.addAll(all2);
            }
        }
        for (Action action : actions) {
            action.getUuidKey().retract();
        }
        for (Condition condition : conditions) {
            condition.getUuidKey().retract();
        }
        for (Column column : all) {
            column.getUuidKey().retract();
        }
        this.reset();
    }

    public RuleInspector addRule(Rule rule) {
        this.index.getRules().add(rule);
        RuleInspector ruleInspector = new RuleInspector(rule, this.checkStorage, this, this.configuration);
        this.add(ruleInspector);
        return ruleInspector;
    }

    public RuleInspector getRuleInspector(int row) {
        return this.ruleInspectors.get(this.getRule(row));
    }

    public AnalyzerConfiguration getConfiguration() {
        return this.configuration;
    }
}

