/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.matchers.UUIDMatchers;
import org.drools.verifier.core.index.model.Fields;
import org.drools.verifier.core.index.model.ObjectType;
import org.drools.verifier.core.index.query.Matchers;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.util.PortablePreconditions;

public class Pattern
implements HasKeys {
    private static final KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").build();
    private static final KeyDefinition BOUND_NAME = KeyDefinition.newKeyDefinition().withId("boundName").build();
    private final UUIDKey uuidKey;
    private final String name;
    private final Fields fields = new Fields();
    private final String boundName;
    private final ObjectType objectType;

    public Pattern(String boundName, ObjectType objectType, AnalyzerConfiguration configuration) {
        this.boundName = PortablePreconditions.checkNotNull("boundName", boundName);
        this.objectType = PortablePreconditions.checkNotNull("objectType", objectType);
        this.name = objectType.getType();
        this.uuidKey = configuration.getUUID(this);
    }

    public static Matchers boundName() {
        return new Matchers(BOUND_NAME);
    }

    public static Matchers name() {
        return new Matchers(NAME);
    }

    public static Matchers uuid() {
        return new UUIDMatchers();
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, NAME, BOUND_NAME};
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    public String getName() {
        return this.name;
    }

    public String getBoundName() {
        return this.boundName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Fields getFields() {
        return this.fields;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, new Key(NAME, (Comparable)((Object)this.name)), new Key(BOUND_NAME, (Comparable)((Object)this.boundName))};
    }
}

