/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.Collection;
import org.drools.verifier.api.Callback;
import org.drools.verifier.core.index.keys.IndexKey;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.matchers.FromMatcher;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.KeyTreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.util.HasIndex;
import org.drools.verifier.core.maps.util.HasKeys;

public class IndexedKeyTreeMap<T extends HasIndex & HasKeys>
extends KeyTreeMap<T> {
    public IndexedKeyTreeMap(KeyDefinition ... keyIDs) {
        super(keyIDs);
    }

    public void put(T object, int index) {
        this.doForAll(index, new Callback<T>(){

            public void callback(T t) {
                t.setIndex(t.getIndex() + 1);
            }
        });
        object.setIndex(index);
        super.put(object);
    }

    private void doForAll(int index, Callback<T> callback) {
        MultiMap map = this.get(IndexKey.INDEX_ID);
        Collection all = new Select(map, new FromMatcher(IndexKey.INDEX_ID, Integer.valueOf(index), true)).all();
        for (HasIndex t : all) {
            callback.callback((Object)t);
        }
    }

    @Override
    protected T remove(UUIDKey uuidKey) {
        HasIndex remove = (HasIndex)super.remove(uuidKey);
        if (remove != null) {
            this.doForAll(remove.getIndex(), new Callback<T>(){

                public void callback(T t) {
                    t.setIndex(t.getIndex() - 1);
                }
            });
        }
        return (T)remove;
    }

    @Override
    public void put(T object) {
        this.put(object, this.resolveMapByKeyId(IndexKey.INDEX_ID).size());
    }
}

