/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.relations;

import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.relations.Conflict;
import org.drools.verifier.core.relations.Conflicts;
import org.drools.verifier.core.relations.IsConflicting;

public class ConflictResolver {
    private final InspectorList collection;
    private final Conflicts conflicts;

    public ConflictResolver(InspectorList list, boolean record) {
        this.collection = list;
        this.conflicts = new Conflicts(record);
    }

    private Conflict isConflicting(InspectorList otherCollection) {
        if (this.collection == null || otherCollection == null) {
            return Conflict.EMPTY;
        }
        for (Object o : this.collection) {
            Conflict conflict;
            if (!(o instanceof IsConflicting) || !(conflict = ConflictResolver.hasConflictingObjectInList(otherCollection, (IsConflicting)o)).foundIssue()) continue;
            return new Conflict(this.collection, otherCollection, conflict);
        }
        return Conflict.EMPTY;
    }

    private static Conflict getConflictingObjects(InspectorList collection, IsConflicting isConflicting) {
        if (isConflicting == null || collection == null) {
            return Conflict.EMPTY;
        }
        for (Object other : collection) {
            Conflict conflicting = ConflictResolver.isConflicting(isConflicting, (HasUUID)other);
            if (!conflicting.foundIssue()) continue;
            return conflicting;
        }
        return Conflict.EMPTY;
    }

    private static Conflict hasConflictingObjectInList(InspectorList collection, IsConflicting isConflicting) {
        return ConflictResolver.getConflictingObjects(collection, isConflicting);
    }

    static Conflict isConflicting(HasUUID isConflicting, HasUUID other) {
        if (isConflicting instanceof IsConflicting && ((IsConflicting)isConflicting).conflicts(other)) {
            return new Conflict(isConflicting, other);
        }
        return Conflict.EMPTY;
    }

    public Conflict resolveConflict(InspectorList otherCollection) {
        Conflict first = this.conflicts.get(otherCollection.getUuidKey());
        if (first != null) {
            if (first.doesRelationStillExist()) {
                return first;
            }
            this.conflicts.remove(first);
            return this.resolveConflict(otherCollection);
        }
        Conflict conflict = this.isConflicting(otherCollection);
        if (conflict.foundIssue()) {
            this.conflicts.add(conflict);
            return conflict;
        }
        return Conflict.EMPTY;
    }
}

