/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.query;

import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Columns;
import org.drools.verifier.core.index.model.ObjectTypes;
import org.drools.verifier.core.index.model.Rules;
import org.drools.verifier.core.index.query.Query;
import org.drools.verifier.core.index.select.QueryCallback;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyTreeMap;

public class QueryableIndex {
    private Rules rules;
    private Columns columns;
    private ObjectTypes objectTypes;

    public QueryableIndex(Rules rules, Columns columns, ObjectTypes objectTypes) {
        this.rules = rules;
        this.columns = columns;
        this.objectTypes = objectTypes;
    }

    private void queryAll(Query query, QueryCallback callback) {
        callback.callback(new Select(this.getMap(query.getMapId()).get(query.getMatcher().getKeyDefinition()), query.getMatcher()).all());
    }

    private KeyTreeMap getMap(String mapId) {
        if ("Rules".equals(mapId)) {
            return this.rules.map;
        }
        if ("Columns".equals(mapId)) {
            return this.columns.map;
        }
        if ("ObjectTypes".equals(mapId)) {
            return this.objectTypes.map;
        }
        throw new IllegalArgumentException("Could not find map with the id: " + mapId);
    }

    private void queryFirst(Query query, QueryCallback callback) {
        callback.callback(new Select(this.getMap(query.getMapId()).get(query.getMatcher().getKeyDefinition()), query.getMatcher()).first());
    }

    private void queryLast(Query query, QueryCallback callback) {
        callback.callback(new Select(this.getMap(query.getMapId()).get(query.getMatcher().getKeyDefinition()), query.getMatcher()).last());
    }

    public Where getRules() {
        return new Where("Rules");
    }

    public Where getColumns() {
        return new Where("Columns");
    }

    public Where getObjectTypes() {
        return new Where("ObjectTypes");
    }

    class Where {
        private Matcher matcher;
        private String mapId;

        public Where(String mapId) {
            this.mapId = mapId;
        }

        public Select where(Matcher matcher) {
            this.matcher = matcher;
            return new Select();
        }

        class Select {
            Select() {
            }

            public Callbacks select() {
                return new Callbacks();
            }

            class Callbacks {
                Callbacks() {
                }

                public void all(QueryCallback callback) {
                    QueryableIndex.this.queryAll(new Query(Where.this.mapId, Where.this.matcher), callback);
                }

                public void first(QueryCallback callback) {
                    QueryableIndex.this.queryFirst(new Query(Where.this.mapId, Where.this.matcher), callback);
                }

                public void last(QueryCallback callback) {
                    QueryableIndex.this.queryLast(new Query(Where.this.mapId, Where.this.matcher), callback);
                }
            }
        }
    }
}

