/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.keys;

import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.keys.Values;
import org.drools.verifier.core.maps.KeyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Key
implements Comparable<Key> {
    private static final Logger LOG = LoggerFactory.getLogger(Key.class);
    private final KeyDefinition keyDefinition;
    private Values<Value> values = new Values();

    public Key(KeyDefinition keyDefinition, Comparable value) {
        this.keyDefinition = keyDefinition;
        this.values.add(new Value(value));
    }

    public Key(KeyDefinition keyDefinition, Values values) {
        this.keyDefinition = keyDefinition;
        for (Object value : values) {
            try {
                this.values.add(new Value((Comparable)value));
            }
            catch (ClassCastException cce) {
                LOG.error("Exception", (Throwable)cce);
            }
        }
    }

    public KeyDefinition getKeyDefinition() {
        return this.keyDefinition;
    }

    public Values<Value> getValues() {
        return this.values;
    }

    public Comparable getSingleValueComparator() {
        return this.getSingleValue().getComparable();
    }

    public Value getSingleValue() {
        return (Value)this.values.iterator().next();
    }

    @Override
    public int compareTo(Key key) {
        return this.keyDefinition.compareTo(key.keyDefinition);
    }
}

