/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Date;

public class ActivationTime {
    private final Date start;
    private final Date end;

    public ActivationTime(Date start, Date end) {
        this.start = start;
        this.end = end;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public boolean overlaps(ActivationTime other) {
        Date max = this.findMaxDate(this.start, other.start);
        Date min = this.findMinDate(this.end, other.end);
        if (min == null || max == null) {
            return true;
        }
        return min.compareTo(max) >= 0;
    }

    private Date findMaxDate(Date date, Date other) {
        if (date == null && other == null) {
            return null;
        }
        if (other == null || date != null && date.after(other)) {
            return date;
        }
        return other;
    }

    private Date findMinDate(Date date, Date other) {
        if (date == null && other == null) {
            return null;
        }
        if (other == null || date != null && date.before(other)) {
            return date;
        }
        return other;
    }
}

