/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.util.HasConflicts;
import org.drools.verifier.core.maps.util.HasRedundancy;
import org.drools.verifier.core.maps.util.HasUUID;
import org.drools.verifier.core.maps.util.RedundancyResult;
import org.drools.verifier.core.relations.Conflict;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsRedundant;

public class LeafInspectorList<T extends IsConflicting & IsRedundant>
extends InspectorList<T>
implements HasConflicts,
HasRedundancy {
    public LeafInspectorList(AnalyzerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Conflict hasConflicts() {
        int index = 1;
        for (IsConflicting inspector : this) {
            for (int j = index; j < this.size(); ++j) {
                if (!inspector.conflicts(this.get(j))) continue;
                return new Conflict(inspector, (HasUUID)this.get(j));
            }
            ++index;
        }
        return Conflict.EMPTY;
    }

    @Override
    public RedundancyResult hasRedundancy() {
        for (int i = 0; i < this.size(); ++i) {
            IsConflicting inspector = (IsConflicting)this.get(i);
            for (int j = i + 1; j < this.size(); ++j) {
                IsConflicting other = (IsConflicting)this.get(j);
                if (!((IsRedundant)((Object)inspector)).isRedundant(other)) continue;
                return new RedundancyResult(new IsRedundant[]{(IsRedundant)((Object)inspector), (IsRedundant)this.get(j)});
            }
        }
        return RedundancyResult.EMPTY;
    }
}

