/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.function.Predicate;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.SingleCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.maps.InspectorList;

public abstract class OneToManyCheck
extends SingleCheck {
    private final InspectorList<RuleInspector> ruleInspectors;
    private Predicate<RuleInspector> filter;

    public OneToManyCheck(RuleInspector ruleInspector, Predicate<RuleInspector> filter, AnalyzerConfiguration configuration, CheckType checkType) {
        this(ruleInspector, configuration, checkType);
        this.filter = filter;
    }

    public OneToManyCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration, CheckType checkType) {
        super(ruleInspector, configuration, checkType);
        this.ruleInspectors = new InspectorList(configuration);
    }

    protected boolean thereIsAtLeastOneRow() {
        return this.getOtherRows().size() >= 1;
    }

    @Override
    public RuleInspector getRuleInspector() {
        return this.ruleInspector;
    }

    public InspectorList<RuleInspector> getOtherRows() {
        this.ruleInspectors.clear();
        this.ruleInspectors.addAll(this.ruleInspector.getCache().all(this.filter));
        return this.ruleInspectors;
    }
}

