/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapChangeHandler;
import org.drools.verifier.core.maps.NewSubMapProvider;

public class RawMultiMap<Key extends Comparable, Value, ListType extends List<Value>>
implements MultiMap<Key, Value, ListType> {
    protected final TreeMap<Key, ListType> map;
    private NewSubMapProvider<Value, ListType> newSubMapProvider;

    public RawMultiMap(NewSubMapProvider<Value, ListType> newSubMapProvider) {
        this.map = new TreeMap();
        this.newSubMapProvider = newSubMapProvider;
    }

    protected RawMultiMap(SortedMap<Key, ListType> map, NewSubMapProvider<Value, ListType> newSubMapProvider) {
        this.map = new TreeMap<Key, ListType>(map);
        this.newSubMapProvider = newSubMapProvider;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private ListType resolveInnerList(Key key) {
        if (this.map.containsKey(key)) {
            return (ListType)((List)this.map.get(key));
        }
        ListType list = this.getNewSubMap();
        this.map.put(key, list);
        return list;
    }

    @Override
    public boolean containsKey(Key key) {
        return this.map.containsKey(key);
    }

    public void put(Key key, int index, Value value) {
        this.resolveInnerList(key).add(index, value);
    }

    @Override
    public boolean put(Key key, Value value) {
        return this.resolveInnerList(key).add(value);
    }

    @Override
    public void move(Set<Key> oldKeys, Set<Key> newKeys, Value value) {
        for (Comparable oldKey : oldKeys) {
            this.removeValue(oldKey, value);
        }
        for (Comparable newKey : newKeys) {
            this.put(newKey, value);
        }
    }

    private ListType getNewSubMap() {
        return this.newSubMapProvider.getNewSubMap();
    }

    @Override
    public ListType get(Key key) {
        return (ListType)((List)this.map.get(key));
    }

    @Override
    public boolean addAllValues(Key key, Collection<Value> values) {
        if (this.map.containsKey(key)) {
            return ((List)this.map.get(key)).addAll(values);
        }
        ListType set = this.getNewSubMap();
        set.addAll(values);
        this.map.put(key, set);
        return true;
    }

    @Override
    public void addChangeListener(MultiMapChangeHandler<Key, Value> multiMapChangeHandler) {
        throw new UnsupportedOperationException("This map " + this.getClass().getName() + " can not have change handlers.");
    }

    @Override
    public Collection<Value> remove(Key key) {
        return (Collection)this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<Key> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Value> allValues() {
        ListType allValues = this.getNewSubMap();
        for (Comparable key : this.keySet()) {
            ListType collection = this.get(key);
            if (collection == null) continue;
            allValues.addAll(collection);
        }
        return allValues;
    }

    @Override
    public Key lastKey() {
        return (Key)((Comparable)this.map.lastKey());
    }

    @Override
    public MultiMap<Key, Value, ListType> subMap(Key fromKey, boolean fromInclusive, Key toKey, boolean toInclusive) {
        return new RawMultiMap<Key, Value, ListType>(this.map.subMap(fromKey, fromInclusive, toKey, toInclusive), this.newSubMapProvider);
    }

    @Override
    public void removeValue(Key key, Value value) {
        this.get(key).remove(value);
    }

    @Override
    public Key firstKey() {
        return (Key)((Comparable)this.map.firstKey());
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void putAllValues(Key key, Collection<Value> values) {
        ListType newSubMap = this.getNewSubMap();
        newSubMap.addAll(values);
        this.map.put(key, newSubMap);
    }
}

