/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.main;

import java.util.HashSet;
import java.util.Set;
import org.drools.verifier.api.Command;
import org.drools.verifier.api.Status;
import org.drools.verifier.api.StatusUpdate;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.core.cache.RuleInspectorCache;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.checks.base.CheckRunManager;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.Index;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.model.Rule;
import org.drools.verifier.core.main.Reporter;
import org.drools.verifier.core.util.PortablePreconditions;

public class Analyzer {
    private final RuleInspectorCache cache;
    private final CheckRunManager checkRunManager;
    private final AnalyzerConfiguration configuration;
    private final Reporter reporter;
    private final StatusUpdate onStatus = this.getOnStatusCommand();
    private final Command onCompletion = this.getOnCompletionCommand();

    public Analyzer(Reporter reporter, Index index, AnalyzerConfiguration configuration) {
        this.reporter = PortablePreconditions.checkNotNull("reporter", reporter);
        this.configuration = PortablePreconditions.checkNotNull("configuration", configuration);
        this.checkRunManager = new CheckRunManager(configuration.getCheckRunner());
        this.cache = new RuleInspectorCache(PortablePreconditions.checkNotNull("index", index), configuration);
        this.cache.reset();
    }

    public void newColumn(Column column) {
        this.cache.newColumn(column);
    }

    public void newRule(Rule rule) {
        RuleInspector ruleInspector = this.cache.addRule(rule);
        this.checkRunManager.addChecks(ruleInspector.getChecks());
    }

    public void deleteColumn(int firstColumnIndex) {
        this.cache.deleteColumns(firstColumnIndex);
    }

    public void resetChecks() {
        for (RuleInspector ruleInspector : this.cache.all()) {
            this.checkRunManager.addChecks(ruleInspector.getChecks());
        }
        this.checkRunManager.addChecks(this.cache.getGeneralChecks());
    }

    private Set<Issue> getIssues() {
        return this.cache.getAllIssues();
    }

    public void removeRule(Integer rowDeleted) {
        this.checkRunManager.remove(this.cache.removeRow(rowDeleted));
        this.analyze();
    }

    public void start() {
        if (this.checkRunManager.isEmpty()) {
            this.resetChecks();
            this.analyze();
        } else {
            this.reporter.sendReport(this.getIssues());
        }
    }

    public void update(Set<Integer> canBeUpdated) {
        HashSet<Check> checks = new HashSet<Check>();
        for (Integer row : canBeUpdated) {
            checks.addAll(this.cache.getRuleInspector(row).getChecks());
        }
        if (!checks.isEmpty()) {
            this.checkRunManager.addChecks(checks);
        }
    }

    public void analyze() {
        this.checkRunManager.run(this.onStatus, this.onCompletion);
    }

    private StatusUpdate getOnStatusCommand() {
        return (currentStartIndex, endIndex, size) -> this.reporter.sendStatus(new Status(this.configuration.getWebWorkerUUID(), currentStartIndex, endIndex, size));
    }

    private Command getOnCompletionCommand() {
        return () -> this.reporter.sendReport(this.getIssues());
    }
}

