/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.matchers.UUIDMatchers;
import org.drools.verifier.core.index.query.Matchers;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.relations.HumanReadable;
import org.drools.verifier.core.util.PortablePreconditions;

public abstract class FieldBase
implements Comparable<FieldBase>,
HasKeys,
HumanReadable {
    private static KeyDefinition NAME = KeyDefinition.newKeyDefinition().withId("name").updatable().build();
    private final UUIDKey uuidKey;
    private final String factType;
    private final String fieldType;
    private final String name;

    public FieldBase(String factType, String fieldType, String name, AnalyzerConfiguration configuration) {
        this.factType = PortablePreconditions.checkNotNull("factType", factType);
        this.fieldType = PortablePreconditions.checkNotNull("fieldType", fieldType);
        this.name = PortablePreconditions.checkNotNull("name", name);
        this.uuidKey = configuration.getUUID(this);
    }

    public static Matchers name() {
        return new Matchers(NAME);
    }

    public static Matchers uuid() {
        return new UUIDMatchers();
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, NAME};
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    public String getFactType() {
        return this.factType;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.factType + "." + this.name;
    }

    @Override
    public int compareTo(FieldBase field) {
        if (this.factType.equals(field.factType) && this.name.equals(field.name)) {
            return 0;
        }
        if (this.factType.equals(field.factType)) {
            return this.name.compareTo(field.name);
        }
        return this.factType.compareTo(field.factType);
    }

    public int hashCode() {
        int result = ~(~this.factType.hashCode());
        result = 31 * result + ~(~this.name.hashCode());
        return ~(~result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldBase field = (FieldBase)o;
        if (!this.factType.equals(field.factType)) {
            return false;
        }
        return this.name.equals(field.name);
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, new Key(NAME, (Comparable)((Object)this.name))};
    }

    @Override
    public String toHumanReadableString() {
        return this.name;
    }
}

