/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.cache.inspectors.condition;

import org.drools.verifier.core.cache.inspectors.condition.BooleanConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.ConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.NumericIntegerConditionInspector;
import org.drools.verifier.core.cache.inspectors.condition.StringConditionInspector;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Condition;
import org.drools.verifier.core.index.model.FieldCondition;
import org.drools.verifier.core.maps.InspectorFactory;

public class ConditionInspectorFactory
extends InspectorFactory<ConditionInspector, Condition> {
    public ConditionInspectorFactory(AnalyzerConfiguration configuration) {
        super(configuration);
    }

    @Override
    public ConditionInspector make(Condition condition) {
        if (condition instanceof FieldCondition) {
            return this.makeFieldCondition((FieldCondition)condition);
        }
        return null;
    }

    private ConditionInspector makeFieldCondition(FieldCondition condition) {
        if (!condition.getValues().isEmpty() && condition.getFirstValue() instanceof String) {
            return new StringConditionInspector((FieldCondition<String>)condition, this.configuration);
        }
        if (!condition.getValues().isEmpty() && condition.getFirstValue() instanceof Boolean) {
            return new BooleanConditionInspector((FieldCondition<Boolean>)condition, this.configuration);
        }
        if (!condition.getValues().isEmpty() && condition.getFirstValue() instanceof Integer) {
            return new NumericIntegerConditionInspector((FieldCondition<Integer>)condition, this.configuration);
        }
        return new ComparableConditionInspector(condition, this.configuration);
    }
}

