/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiSet<K, V> {
    private Map<K, HashSet<V>> map = new HashMap<K, HashSet<V>>();

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean put(K key, V value) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).add(value);
        }
        HashSet<V> list = new HashSet<V>();
        list.add(value);
        this.map.put(key, list);
        return true;
    }

    public void putAllValues(K key, HashSet<V> values) {
        this.map.put(key, values);
    }

    public boolean addAllValues(K key, Collection<V> values) {
        if (this.map.containsKey(key)) {
            return this.map.get(key).addAll(values);
        }
        HashSet<V> set = new HashSet<V>();
        set.addAll(values);
        this.map.put(key, set);
        return true;
    }

    public Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public Collection<V> get(K key) {
        return this.map.get(key);
    }

    public void clear() {
        this.map.clear();
    }

    public List<V> allValues() {
        ArrayList<V> allValues = new ArrayList<V>();
        for (K k : this.keys()) {
            allValues.addAll(this.get(k));
        }
        return allValues;
    }

    public void removeValue(K k, V v) {
        this.get(k).remove(v);
    }
}

