/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import java.util.Collection;
import java.util.Set;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.maps.InspectorList;
import org.drools.verifier.core.maps.LeafInspectorList;
import org.drools.verifier.core.maps.MultiMap;
import org.drools.verifier.core.maps.MultiMapFactory;
import org.drools.verifier.core.maps.NewSubMapProvider;
import org.drools.verifier.core.maps.util.HasConflicts;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.maps.util.HasRedundancy;
import org.drools.verifier.core.maps.util.RedundancyResult;
import org.drools.verifier.core.relations.Conflict;
import org.drools.verifier.core.relations.IsConflicting;
import org.drools.verifier.core.relations.IsRedundant;
import org.drools.verifier.core.relations.IsSubsuming;

public class InspectorMultiMap<GroupBy extends Comparable, Value extends IsConflicting & IsRedundant>
implements HasConflicts,
HasRedundancy,
IsConflicting,
IsRedundant,
IsSubsuming,
HasKeys {
    private final UUIDKey uuidKey;
    private MultiMap<GroupBy, Value, LeafInspectorList<Value>> map;

    public InspectorMultiMap(final AnalyzerConfiguration configuration) {
        this.uuidKey = configuration.getUUID(this);
        this.map = MultiMapFactory.make(true, new NewSubMapProvider<Value, LeafInspectorList<Value>>(){

            @Override
            public LeafInspectorList<Value> getNewSubMap() {
                return new LeafInspectorList(configuration);
            }
        });
    }

    @Override
    public Conflict hasConflicts() {
        for (Comparable groupBy : this.map.keySet()) {
            Conflict result = this.map.get(groupBy).hasConflicts();
            if (!result.foundIssue()) continue;
            return result;
        }
        return Conflict.EMPTY;
    }

    @Override
    public RedundancyResult<GroupBy, Value> hasRedundancy() {
        for (Comparable groupBy : this.map.keySet()) {
            RedundancyResult result = this.map.get(groupBy).hasRedundancy();
            if (!result.isTrue()) continue;
            return new RedundancyResult(groupBy, result);
        }
        return RedundancyResult.EMPTY;
    }

    public boolean conflicts(Object other) {
        if (other instanceof InspectorMultiMap) {
            for (Comparable groupBy : this.map.keySet()) {
                InspectorList list = ((InspectorMultiMap)other).map.get(groupBy);
                if (!(list instanceof InspectorList) || !this.map.get(groupBy).conflicts(list)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRedundant(Object other) {
        if (other instanceof InspectorMultiMap) {
            for (Comparable groupBy : this.map.keySet()) {
                if (this.map.get(groupBy).isRedundant(((InspectorMultiMap)other).map.get(groupBy))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean subsumes(Object other) {
        if (other instanceof InspectorMultiMap) {
            for (GroupBy groupBy : ((InspectorMultiMap)other).map.keySet()) {
                LeafInspectorList<Value> collection;
                InspectorList otherCollection = ((InspectorMultiMap)other).map.get((Comparable)groupBy);
                if (otherCollection.subsumes(collection = this.map.get((Comparable)groupBy))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey};
    }

    public Set<GroupBy> keySet() {
        return this.map.keySet();
    }

    public LeafInspectorList<Value> get(GroupBy groupBy) {
        return this.map.get(groupBy);
    }

    public void putAllValues(GroupBy groupBy, LeafInspectorList<Value> values) {
        this.map.putAllValues(groupBy, values);
    }

    public void put(GroupBy groupBy, Value value) {
        this.map.put(groupBy, value);
    }

    public void addAllValues(GroupBy groupBy, InspectorList<Value> list) {
        this.map.addAllValues(groupBy, list);
    }

    public Collection<Value> allValues() {
        return this.map.allValues();
    }
}

