/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks.base;

import java.util.Optional;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.checks.base.Check;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.configuration.CheckConfiguration;
import org.drools.verifier.core.util.PortablePreconditions;

public abstract class CheckBase
implements Check {
    protected final AnalyzerConfiguration configuration;
    protected boolean hasIssues = false;

    public CheckBase(AnalyzerConfiguration configuration) {
        this.configuration = PortablePreconditions.checkNotNull("configuration", configuration);
    }

    @Override
    public boolean hasIssues() {
        return this.hasIssues;
    }

    @Override
    public final Issue getIssue() {
        return this.makeIssue(this.resolveSeverity(), this.getCheckType());
    }

    protected abstract Issue makeIssue(Severity var1, CheckType var2);

    protected abstract CheckType getCheckType();

    protected abstract Severity getDefaultSeverity();

    @Override
    public boolean isActive(CheckConfiguration checkConfiguration) {
        return checkConfiguration.getCheckConfiguration().contains(this.getCheckType());
    }

    protected Severity resolveSeverity() {
        Optional<Severity> severityOverwrite = this.configuration.getCheckConfiguration().getSeverityOverwrite(this.getCheckType());
        if (severityOverwrite.isPresent()) {
            return severityOverwrite.get();
        }
        return this.getDefaultSeverity();
    }
}

