/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.Arrays;
import java.util.HashSet;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.PairCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.configuration.CheckConfiguration;

public class DetectRedundantRowsCheck
extends PairCheck {
    private CheckType issueType = null;
    private boolean allowRedundancyReporting = true;
    private boolean allowSubsumptionReporting = true;

    public DetectRedundantRowsCheck(RuleInspector ruleInspector, RuleInspector other, AnalyzerConfiguration configuration) {
        super(ruleInspector, other, configuration);
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new Issue(severity, checkType, new HashSet<Integer>(Arrays.asList(this.ruleInspector.getRowIndex() + 1, this.other.getRowIndex() + 1)));
    }

    @Override
    public boolean isActive(CheckConfiguration checkConfiguration) {
        this.allowRedundancyReporting = checkConfiguration.getCheckConfiguration().contains(CheckType.REDUNDANT_ROWS);
        this.allowSubsumptionReporting = checkConfiguration.getCheckConfiguration().contains(CheckType.SUBSUMPTANT_ROWS);
        return this.allowRedundancyReporting || this.allowSubsumptionReporting;
    }

    @Override
    protected CheckType getCheckType() {
        return this.issueType;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.WARNING;
    }

    @Override
    public boolean check() {
        if (this.other.atLeastOneActionHasAValue() && this.ruleInspector.subsumes(this.other)) {
            if (this.allowRedundancyReporting && this.other.subsumes(this.ruleInspector)) {
                this.issueType = CheckType.REDUNDANT_ROWS;
                this.hasIssues = true;
                return true;
            }
            if (this.allowSubsumptionReporting) {
                this.issueType = CheckType.SUBSUMPTANT_ROWS;
                this.hasIssues = true;
                return true;
            }
        }
        this.hasIssues = false;
        return false;
    }
}

