/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import java.util.Collection;
import org.drools.verifier.core.index.matchers.ExactMatcher;
import org.drools.verifier.core.index.matchers.KeyMatcher;
import org.drools.verifier.core.index.matchers.Matcher;
import org.drools.verifier.core.index.model.Action;
import org.drools.verifier.core.index.model.Column;
import org.drools.verifier.core.index.query.MapBy;
import org.drools.verifier.core.index.query.Where;
import org.drools.verifier.core.index.select.Listen;
import org.drools.verifier.core.index.select.Select;
import org.drools.verifier.core.maps.KeyTreeMap;

public class Actions {
    private final KeyTreeMap<Action> map = new KeyTreeMap(Action.keyDefinitions());

    public Actions() {
    }

    public Actions(Collection<Action> actions) {
        for (Action action : actions) {
            this.add(action);
        }
    }

    public void add(Action action) {
        this.map.put(action);
    }

    public void merge(Actions actions) {
        this.map.merge(actions.map);
    }

    public Where<ActionSelect, ActionListen> where(final Matcher matcher) {
        return new Where<ActionSelect, ActionListen>(){

            @Override
            public ActionSelect select() {
                return new ActionSelect(matcher);
            }

            @Override
            public ActionListen listen() {
                return new ActionListen(matcher);
            }
        };
    }

    public <KeyType> MapBy<KeyType, Action> mapBy(KeyMatcher matcher) {
        return new MapBy(this.map.get(matcher.getKeyDefinition()));
    }

    public void remove(Column column) {
        ExactMatcher matcher = Action.columnUUID().is(column.getUuidKey());
        for (Action action : this.where(matcher).select().all()) {
            action.getUuidKey().retract();
        }
    }

    public class ActionListen
    extends Listen<Action> {
        public ActionListen(Matcher matcher) {
            super(Actions.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }

    public class ActionSelect
    extends Select<Action> {
        public ActionSelect(Matcher matcher) {
            super(Actions.this.map.get(matcher.getKeyDefinition()), matcher);
        }
    }
}

