/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.maps;

import org.drools.verifier.core.util.PortablePreconditions;

public class KeyDefinition
implements Comparable<KeyDefinition> {
    private final String id;
    private boolean updatable;

    private KeyDefinition(String id) {
        this.id = PortablePreconditions.checkNotNull("id", id);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(KeyDefinition other) {
        return this.id.compareTo(other.id);
    }

    public static Builder newKeyDefinition() {
        return new Builder();
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public static class Builder {
        private String id;
        private boolean updatable = false;

        public Builder withId(String id) {
            this.id = PortablePreconditions.checkNotNull("id", id);
            return this;
        }

        public KeyDefinition build() {
            PortablePreconditions.checkNotNull("id", this.id);
            KeyDefinition keyDefinition = new KeyDefinition(this.id);
            keyDefinition.updatable = this.updatable;
            return keyDefinition;
        }

        public Builder updatable() {
            this.updatable = true;
            return this;
        }
    }
}

