/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Severity;

public class CheckConfiguration {
    private final Set<CheckType> configurations = new HashSet<CheckType>();
    private final Map<CheckType, Severity> severityOverwrites = new HashMap<CheckType, Severity>();

    private CheckConfiguration() {
    }

    public static CheckConfiguration newDefault() {
        CheckConfiguration checkConfiguration = new CheckConfiguration();
        checkConfiguration.getCheckConfiguration().addAll(Arrays.asList(CheckType.values()));
        return checkConfiguration;
    }

    public static CheckConfiguration newEmpty() {
        return new CheckConfiguration();
    }

    public Set<CheckType> getCheckConfiguration() {
        return this.configurations;
    }

    public void setSeverityOverwrites(CheckType checkType, Severity severity) {
        this.severityOverwrites.put(checkType, severity);
    }

    public Optional<Severity> getSeverityOverwrite(CheckType checkType) {
        if (this.severityOverwrites.containsKey(checkType)) {
            return Optional.of(this.severityOverwrites.get(checkType));
        }
        return Optional.empty();
    }
}

