/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import java.util.Collections;
import java.util.Optional;
import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.ImpossibleMatchIssue;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.core.cache.inspectors.PatternInspector;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.cache.inspectors.condition.ComparableConditionInspector;
import org.drools.verifier.core.checks.base.SingleCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.model.Field;
import org.drools.verifier.core.maps.InspectorMultiMap;
import org.drools.verifier.core.relations.Conflict;
import org.drools.verifier.core.relations.HumanReadable;

public class DetectImpossibleMatchCheck
extends SingleCheck {
    private Conflict conflict = Conflict.EMPTY;

    public DetectImpossibleMatchCheck(RuleInspector ruleInspector, AnalyzerConfiguration configuration) {
        super(ruleInspector, configuration, CheckType.IMPOSSIBLE_MATCH);
    }

    @Override
    public boolean check() {
        this.conflict = this.ruleInspector.getPatternsInspector().stream().map(PatternInspector::getConditionsInspector).map(InspectorMultiMap::hasConflicts).filter(Conflict::foundIssue).findFirst().orElse(Conflict.EMPTY);
        this.hasIssues = this.conflict != Conflict.EMPTY;
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.ERROR;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new ImpossibleMatchIssue(severity, checkType, Integer.toString(this.ruleInspector.getRowIndex() + 1), this.getFactType(), this.getFieldName(), HumanReadable.toHumanReadableString(((Conflict)this.conflict.getOrigin()).getConflictedItem()), HumanReadable.toHumanReadableString(((Conflict)this.conflict.getOrigin()).getConflictingItem()), Collections.singleton(this.ruleInspector.getRowIndex() + 1));
    }

    private String getFieldName() {
        Optional<Field> field = this.getField();
        if (field.isPresent()) {
            return field.get().getName();
        }
        return "";
    }

    private String getFactType() {
        Optional<Field> field = this.getField();
        if (field.isPresent()) {
            return field.get().getFactType();
        }
        return "";
    }

    private Optional<Field> getField() {
        if (((Conflict)this.conflict.getOrigin()).getConflictedItem() instanceof ComparableConditionInspector) {
            Field field = ((ComparableConditionInspector)((Conflict)this.conflict.getOrigin()).getConflictedItem()).getField();
            return Optional.of(field);
        }
        return Optional.empty();
    }
}

