/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.checks;

import org.drools.verifier.api.reporting.CheckType;
import org.drools.verifier.api.reporting.Issue;
import org.drools.verifier.api.reporting.Severity;
import org.drools.verifier.api.reporting.SingleHitLostIssue;
import org.drools.verifier.core.cache.inspectors.RuleInspector;
import org.drools.verifier.core.checks.base.PairCheck;
import org.drools.verifier.core.configuration.AnalyzerConfiguration;

public class SingleHitCheck
extends PairCheck {
    public SingleHitCheck(RuleInspector ruleInspector, RuleInspector other, AnalyzerConfiguration configuration) {
        super(ruleInspector, other, configuration);
    }

    @Override
    protected CheckType getCheckType() {
        return CheckType.SINGLE_HIT_LOST;
    }

    @Override
    public boolean check() {
        this.hasIssues = this.ruleInspector.getConditionsInspectors().subsumes(this.other.getConditionsInspectors()) && this.ruleInspector.getBrlConditionsInspectors().subsumes(this.other.getBrlConditionsInspectors());
        return this.hasIssues;
    }

    @Override
    protected Severity getDefaultSeverity() {
        return Severity.NOTE;
    }

    @Override
    protected Issue makeIssue(Severity severity, CheckType checkType) {
        return new SingleHitLostIssue(severity, checkType, Integer.toString(this.ruleInspector.getRowIndex() + 1), Integer.toString(this.other.getRowIndex() + 1));
    }
}

