/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.index.model;

import org.drools.verifier.core.configuration.AnalyzerConfiguration;
import org.drools.verifier.core.index.keys.IndexKey;
import org.drools.verifier.core.index.keys.Key;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UpdatableKey;
import org.drools.verifier.core.index.keys.Value;
import org.drools.verifier.core.index.matchers.ComparableMatchers;
import org.drools.verifier.core.index.matchers.UUIDMatchers;
import org.drools.verifier.core.index.model.Actions;
import org.drools.verifier.core.index.model.Conditions;
import org.drools.verifier.core.index.model.Patterns;
import org.drools.verifier.core.index.query.Matchers;
import org.drools.verifier.core.maps.KeyDefinition;
import org.drools.verifier.core.maps.util.HasIndex;
import org.drools.verifier.core.maps.util.HasKeys;

public class Rule
implements Comparable<Rule>,
HasKeys,
HasIndex {
    private final Patterns patterns = new Patterns();
    private final Actions actions = new Actions();
    private final Conditions conditions = new Conditions();
    private final UUIDKey uuidKey;
    private UpdatableKey<Rule> indexKey;

    public Rule(Integer rowNumber, AnalyzerConfiguration configuration) {
        this.indexKey = new UpdatableKey(IndexKey.INDEX_ID, rowNumber);
        this.uuidKey = configuration.getUUID(this);
    }

    public static Matchers uuid() {
        return new UUIDMatchers();
    }

    public static ComparableMatchers index() {
        return new ComparableMatchers(IndexKey.INDEX_ID);
    }

    public static KeyDefinition[] keyDefinitions() {
        return new KeyDefinition[]{UUIDKey.UNIQUE_UUID, IndexKey.INDEX_ID};
    }

    public Integer getRowNumber() {
        return this.getIndex();
    }

    public Patterns getPatterns() {
        return this.patterns;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public Actions getActions() {
        return this.actions;
    }

    @Override
    public int compareTo(Rule rule) {
        return 0;
    }

    @Override
    public Key[] keys() {
        return new Key[]{this.uuidKey, this.indexKey};
    }

    @Override
    public UUIDKey getUuidKey() {
        return this.uuidKey;
    }

    @Override
    public int getIndex() {
        return (Integer)this.indexKey.getSingleValueComparator();
    }

    @Override
    public void setIndex(int index) {
        if (this.indexKey.getSingleValue().equals(new Value(Integer.valueOf(index)))) {
            return;
        }
        UpdatableKey<Rule> oldKey = this.indexKey;
        UpdatableKey newKey = new UpdatableKey(IndexKey.INDEX_ID, Integer.valueOf(index));
        this.indexKey = newKey;
        oldKey.update(newKey, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return this.uuidKey.equals(rule.uuidKey);
    }

    public int hashCode() {
        return this.uuidKey.hashCode();
    }
}

