/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.core.configuration;

import java.util.Date;
import org.drools.verifier.core.checks.base.CheckRunner;
import org.drools.verifier.core.configuration.CheckConfiguration;
import org.drools.verifier.core.configuration.DateTimeFormatProvider;
import org.drools.verifier.core.index.keys.UUIDKey;
import org.drools.verifier.core.index.keys.UUIDKeyProvider;
import org.drools.verifier.core.maps.util.HasKeys;
import org.drools.verifier.core.util.PortablePreconditions;

public class AnalyzerConfiguration {
    private final UUIDKeyProvider uuidKeyProvider;
    private final String webWorkerUUID;
    private final DateTimeFormatProvider dateTimeFormatter;
    private final CheckConfiguration checkConfiguration;
    private final CheckRunner checkRunner;

    public AnalyzerConfiguration(String webWorkerUUID, DateTimeFormatProvider dateTimeFormatter, UUIDKeyProvider uuidKeyProvider, CheckConfiguration checkConfiguration, CheckRunner checkRunner) {
        this.webWorkerUUID = PortablePreconditions.checkNotNull("webWorkerUUID", webWorkerUUID);
        this.dateTimeFormatter = PortablePreconditions.checkNotNull("dateTimeFormatter", dateTimeFormatter);
        this.uuidKeyProvider = PortablePreconditions.checkNotNull("uuidKeyProvider", uuidKeyProvider);
        this.checkConfiguration = PortablePreconditions.checkNotNull("checkConfiguration", checkConfiguration);
        this.checkRunner = PortablePreconditions.checkNotNull("checkRunner", checkRunner);
    }

    public String getWebWorkerUUID() {
        return this.webWorkerUUID;
    }

    public UUIDKey getUUID(HasKeys hasKeys) {
        return this.uuidKeyProvider.get(hasKeys);
    }

    public String formatDate(Date dateValue) {
        return this.dateTimeFormatter.format(dateValue);
    }

    public CheckConfiguration getCheckConfiguration() {
        return this.checkConfiguration;
    }

    public CheckRunner getCheckRunner() {
        return this.checkRunner;
    }
}

