/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static File getFile(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        File toReturn = ResourceHelper.getFileResourcesByExtension(extension).stream().filter(file -> file.getName().equals(fileName)).findFirst().orElse(null);
        if (toReturn == null) {
            throw new IllegalArgumentException("Failed to find file " + fileName);
        }
        return toReturn;
    }

    public static File getFile(String fileName, String parentDir) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        File parentDirectory = new File(parentDir);
        if (!(parentDirectory.exists() && parentDirectory.canRead() && parentDirectory.isDirectory())) {
            throw new IllegalArgumentException("Failed to find parent directory " + parentDir);
        }
        File toReturn = ResourceHelper.getFileResourcesByExtension(extension).stream().filter(file -> file.getName().equals(fileName) && file.getParentFile() != null && file.getParentFile().getAbsolutePath().equals(parentDirectory.getAbsolutePath())).findFirst().orElse(null);
        if (toReturn == null) {
            throw new IllegalArgumentException("Failed to find file " + fileName);
        }
        return toReturn;
    }

    public static FileInputStream getFileInputStream(String fileName) throws IOException {
        File sourceFile = FileUtils.getFile(fileName);
        return new FileInputStream(sourceFile);
    }

    public static FileInputStream getFileInputStream(String fileName, String parentDir) throws IOException {
        File sourceFile = FileUtils.getFile(fileName, parentDir);
        return new FileInputStream(sourceFile);
    }

    public static String getFileContent(String fileName) throws IOException {
        File file = FileUtils.getFile(fileName);
        Path path = file.toPath();
        Stream<String> lines = Files.lines(path);
        String toReturn = lines.collect(Collectors.joining("\n"));
        lines.close();
        return toReturn;
    }

    public static String getFileContent(String fileName, String parentDir) throws IOException {
        File file = FileUtils.getFile(fileName, parentDir);
        Path path = file.toPath();
        Stream<String> lines = Files.lines(path);
        String toReturn = lines.collect(Collectors.joining("\n"));
        lines.close();
        return toReturn;
    }

    public static Optional<InputStream> getInputStreamFromFileNameAndClassLoader(String fileName, ClassLoader classLoader) {
        return Optional.ofNullable(classLoader.getResourceAsStream(fileName));
    }

    public static void deleteDirectory(Path path) {
        block8: {
            try {
                if (!Files.exists(path, new LinkOption[0])) break block8;
                try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

