/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.core.util.Entry;
import org.drools.traits.core.factmodel.Triple;
import org.drools.traits.core.factmodel.TripleImpl;
import org.kie.api.runtime.rule.Variable;

public class TripleStore
implements Externalizable {
    public static final String TYPE = "rdfs:type";
    public static final String PROXY = "drools:proxy";
    public static final String VALUE = "drools:hasValue";
    private String id;
    private Map<Triple, Triple> map;

    public TripleStore() {
        this.map = new Object2ObjectOpenCustomHashMap((Hash.Strategy)TripleKeyComparator.getInstance());
    }

    public TripleStore(int capacity, float loadFactor) {
        this.map = new Object2ObjectOpenCustomHashMap(capacity, loadFactor, (Hash.Strategy)TripleKeyComparator.getInstance());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.map = (Map)in.readObject();
        this.id = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.map);
        out.writeObject(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean put(Triple triple, boolean checkExists) {
        return this.put(triple);
    }

    public boolean put(Triple triple) {
        Object val = triple.getValue();
        ((TripleImpl)triple).setValue(Variable.v);
        Triple prev = this.map.compute(triple, (key, existing) -> {
            if (existing != null) {
                ((TripleImpl)existing).setValue(val);
                return existing;
            }
            return key;
        });
        ((TripleImpl)triple).setValue(val);
        return prev != triple;
    }

    public boolean add(Triple triple) {
        this.map.put(triple, triple);
        return false;
    }

    public Triple get(Triple triple) {
        return this.map.get(triple);
    }

    public Collection<Triple> getAll(Triple triple) {
        ArrayList<Triple> list = new ArrayList<Triple>();
        if (triple.getInstance() != Variable.v && triple.getProperty() != Variable.v) {
            TripleCollector collector = new TripleCollector(list, triple);
            this.map.get(collector);
            return list;
        }
        for (Triple tx : this.map.values()) {
            if (!TripleKeyComparator.getInstance().equals(triple, tx)) continue;
            list.add(tx);
        }
        return list;
    }

    public int removeAll(Triple triple) {
        int removed = 0;
        Collection<Triple> coll = this.getAll(triple);
        for (Triple t : coll) {
            if (!this.remove(t)) continue;
            ++removed;
        }
        return removed;
    }

    public boolean remove(Triple triple) {
        return this.map.remove(triple) != null;
    }

    public boolean contains(Triple triple) {
        return this.map.containsKey(triple);
    }

    public int size() {
        return this.map.size();
    }

    public class TripleCollector
    implements Triple {
        List<Triple> list;
        private Triple triple;

        public TripleCollector(List<Triple> list, Triple triple) {
            this.list = list;
            this.triple = triple;
        }

        public void setNext(Entry next) {
        }

        public Entry getNext() {
            return null;
        }

        @Override
        public Object getInstance() {
            return this.triple.getInstance();
        }

        @Override
        public Object getProperty() {
            return this.triple.getProperty();
        }

        @Override
        public Object getValue() {
            return Variable.v;
        }
    }

    public static class TripleKeyComparator
    implements Hash.Strategy,
    Serializable {
        private static TripleKeyComparator INSTANCE = new TripleKeyComparator();

        public static TripleKeyComparator getInstance() {
            return INSTANCE;
        }

        public int hashCode(Object object) {
            Triple t = (Triple)object;
            int prime = 31;
            int result = 1;
            result = 31 * result + t.getInstance().hashCode();
            result = 31 * result + t.getProperty().hashCode();
            if (t instanceof TripleImpl) {
                ((TripleImpl)t).hash = result;
            }
            return result;
        }

        public boolean equals(Object object1, Object object2) {
            if (object1 == null || object2 == null) {
                return object1 == object2;
            }
            Triple t1 = (Triple)object1;
            Triple t2 = (Triple)object2;
            if (t1.getInstance() != Variable.v) {
                if (t1.getInstance() == null) {
                    return false;
                }
                if (t1.getInstance() instanceof String ? !t1.getInstance().equals(t2.getInstance()) : t1.getInstance() != t2.getInstance()) {
                    return false;
                }
            }
            if (t1.getProperty() != Variable.v && !t1.getProperty().equals(t2.getProperty())) {
                return false;
            }
            if (t1.getValue() != Variable.v) {
                if (t1.getValue() == null) {
                    return t2.getValue() == null;
                }
                return t1.getValue().equals(t2.getValue());
            }
            if (t1.getClass() == TripleCollector.class) {
                ((TripleCollector)t1).list.add(t2);
                return false;
            }
            return true;
        }
    }
}

