/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.core.factmodel.traits.TraitUtils;
import org.drools.traits.core.factmodel.CodedHierarchy;
import org.drools.traits.core.factmodel.LatticeElement;

public abstract class AbstractBitwiseHierarchyImpl<H, J extends LatticeElement<H>>
implements Externalizable,
CodedHierarchy<H> {
    protected SortedMap<BitSet, J> line = new TreeMap<BitSet, J>(new HierCodeComparator());
    protected boolean fixedRoot = false;

    @Override
    public int size() {
        return this.fixedRoot ? this.line.size() - 1 : this.line.size();
    }

    protected J getNodeByKey(BitSet key) {
        return (J)((LatticeElement)this.line.get(key));
    }

    protected abstract J getNode(H var1);

    protected void remove(J node) {
        this.line.remove(node.getBitMask());
    }

    protected boolean contains(J node) {
        return this.line.containsKey(node.getBitMask());
    }

    @Override
    public BitSet getCode(H val) {
        if (val == null) {
            return null;
        }
        J node = this.getNode(val);
        return node != null ? node.getBitMask() : null;
    }

    @Override
    public BitSet metMembersCode(Collection<H> vals) {
        BitSet x = new BitSet(this.size());
        for (H val : vals) {
            x.or(this.getNode(val).getBitMask());
        }
        return x;
    }

    @Override
    public BitSet jointMembersCode(Collection<H> vals) {
        BitSet x = new BitSet(this.size());
        boolean first = true;
        for (H val : vals) {
            if (first) {
                first = false;
                x.or(this.getNode(val).getBitMask());
                continue;
            }
            x.and(this.getNode(val).getBitMask());
        }
        return x;
    }

    @Override
    public BitSet meetCode(Collection<BitSet> codes) {
        BitSet x = new BitSet(this.size());
        for (BitSet code : codes) {
            x.or(code);
        }
        return x;
    }

    @Override
    public BitSet joinCode(Collection<BitSet> codes) {
        BitSet x = new BitSet(this.size());
        boolean first = true;
        for (BitSet code : codes) {
            if (first) {
                first = false;
                x.or(code);
                continue;
            }
            x.and(code);
        }
        return x;
    }

    @Override
    public List<H> getSortedMembers() {
        ArrayList anx = new ArrayList(this.size());
        for (LatticeElement node : this.getNodes()) {
            if (node.getValue() == null) continue;
            anx.add(node.getValue());
        }
        return anx;
    }

    @Override
    public Collection<H> upperAncestors(BitSet key) {
        LinkedList<Object> vals = new LinkedList<Object>();
        int l = key.length();
        BitSet start = new BitSet(l);
        BitSet end = new BitSet(l);
        int index = 0;
        H rootVal = this.getMember(new BitSet());
        if (rootVal != null) {
            vals.add(rootVal);
        }
        while (index >= 0) {
            int s = index;
            int t = key.nextClearBit(s);
            start.clear();
            start.set(s, true);
            end.set(s, t, true);
            if (t > 0) {
                for (LatticeElement val : this.line.subMap(start, this.nextKey(end)).values()) {
                    vals.add(val.getValue());
                }
            }
            index = key.nextSetBit(t);
        }
        return vals;
    }

    @Override
    public Collection<H> lowerBorder(BitSet key) {
        return this.gcs(key, true);
    }

    @Override
    public Collection<H> immediateChildren(BitSet key) {
        return this.gcs(key, false);
    }

    Collection<H> gcs(BitSet key, boolean includeEquals) {
        LinkedList vals = new LinkedList();
        List<J> border = this.gcsBorderNodes(key, includeEquals);
        for (int j = 0; j < border.size(); ++j) {
            LatticeElement node = (LatticeElement)border.get(j);
            if (node == null) continue;
            vals.add(node.getValue());
        }
        return vals;
    }

    List<J> gcsBorderNodes(BitSet key, boolean includeEquals) {
        LinkedList<LatticeElement> border = new LinkedList<LatticeElement>();
        int l = key.length();
        int n = this.line.size() != 0 ? this.line.lastKey().length() : 0;
        BitSet start = new BitSet(n);
        BitSet end = new BitSet(n);
        start.or(key);
        if (l > n) {
            return border;
        }
        if (l > 0) {
            start.set(l - 1);
        }
        end.set(n);
        for (LatticeElement val : this.line.subMap(start, end).values()) {
            BitSet candidate = val.getBitMask();
            boolean minimal = true;
            int check = this.superset(candidate, key);
            if ((!includeEquals || check < 0) && (includeEquals || check <= 0)) continue;
            for (int k = 0; k < border.size(); ++k) {
                LatticeElement ex = (LatticeElement)border.get(k);
                if (ex == null) continue;
                if (this.superset(candidate, ex.getBitMask()) >= 0) {
                    minimal = false;
                    break;
                }
                if (this.superset(ex.getBitMask(), candidate) <= 0) continue;
                border.set(k, null);
            }
            if (!minimal) continue;
            border.add(val);
        }
        return border;
    }

    Collection<H> lcs(BitSet key, boolean includeEquals) {
        LinkedList vals = new LinkedList();
        List<J> border = this.lcsBorderNodes(key, includeEquals);
        for (int j = 0; j < border.size(); ++j) {
            LatticeElement node = (LatticeElement)border.get(j);
            if (node == null) continue;
            vals.add(node.getValue());
        }
        return vals;
    }

    List<J> lcsBorderNodes(BitSet key, boolean includeEquals) {
        ArrayList<LatticeElement> border = new ArrayList<LatticeElement>();
        if (key == null) {
            return border;
        }
        int l = key.length();
        BitSet start = new BitSet(l + 1);
        BitSet end = new BitSet(l + 1);
        int index = 0;
        LatticeElement root = (LatticeElement)this.line.get(new BitSet());
        if (root != null) {
            border.add(root);
        }
        while (index >= 0) {
            int s = index;
            int t = key.nextClearBit(s);
            start.clear();
            start.set(s, true);
            end.set(s, t, true);
            for (LatticeElement val : this.line.subMap(start, this.nextKey(end)).values()) {
                BitSet candidate = val.getBitMask();
                int comp = this.superset(key, candidate);
                if ((!includeEquals || comp < 0) && (includeEquals || comp <= 0)) continue;
                border.add(val);
                for (int j = 0; j < border.size(); ++j) {
                    LatticeElement ex = (LatticeElement)border.get(j);
                    if (ex == null || this.superset(candidate, ex.getBitMask()) <= 0) continue;
                    border.set(j, null);
                }
            }
            index = key.nextSetBit(t);
        }
        return border;
    }

    protected String toBinaryString(BitSet mask) {
        return this.toBinaryString(mask, mask.length());
    }

    protected String toBinaryString(BitSet mask, int len) {
        StringBuilder sb = new StringBuilder();
        for (int j = len - 1; j >= 0; --j) {
            sb.append(mask.get(j) ? "1 " : "0 ");
        }
        return sb.toString();
    }

    BitSet prevKey(BitSet key) {
        BitSet b = new BitSet(key.length());
        b.or(key);
        int x = key.nextSetBit(0);
        if (x == 0) {
            b.clear(0);
        } else {
            b.set(0, x, true);
            b.clear(x);
        }
        return b;
    }

    BitSet nextKey(BitSet key) {
        int l = key.length();
        if (l == 0) {
            BitSet b = new BitSet(1);
            b.set(0);
            return b;
        }
        BitSet b = new BitSet(l + 1);
        b.or(key);
        int x = key.nextSetBit(0);
        if (x == 0) {
            int y = b.nextClearBit(0);
            b.set(x, y, false);
            b.set(y);
        } else {
            b.set(0);
        }
        return b;
    }

    int superset(J n1, J n2) {
        return this.superset(n1.getBitMask(), n2.getBitMask());
    }

    public int superset(BitSet n1, BitSet n2) {
        if (n1.equals(n2)) {
            return 0;
        }
        return TraitUtils.supersetOrEqualset((BitSet)n1, (BitSet)n2) ? 1 : -1;
    }

    protected int numBit(BitSet x) {
        return x.length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.fixedRoot);
        objectOutput.writeObject(this.line);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.fixedRoot = objectInput.readBoolean();
        this.line = (SortedMap)objectInput.readObject();
    }

    public static BitSet stringToBitSet(String s) {
        BitSet b = new BitSet();
        int n = s.length();
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) == '1') {
                b.set(n - j - 1);
                continue;
            }
            if (s.charAt(j) == '0') continue;
            throw new IllegalStateException("The string " + s + " is not a valid bitset encoding");
        }
        return b;
    }

    @Override
    public void removeMember(H val) {
        System.out.println(">>>>>>************* it should not happen");
    }

    @Override
    public void removeMember(BitSet key) {
        LatticeElement node = (LatticeElement)this.line.get(key);
        this.remove(node);
    }

    @Override
    public Map<H, BitSet> getSortedMap() {
        LinkedHashMap anx = new LinkedHashMap(this.size());
        for (LatticeElement node : this.getNodes()) {
            if (node.getValue() == null) continue;
            anx.put(node.getValue(), node.getBitMask());
        }
        return anx;
    }

    @Override
    public boolean hasKey(BitSet key) {
        return this.line.containsKey(key);
    }

    @Override
    public Collection<H> lowerDescendants(BitSet key) {
        LinkedList vals = new LinkedList();
        int l = key.length();
        if (l == 0 || this.line.isEmpty()) {
            return new ArrayList<H>(this.getSortedMembers());
        }
        int n = this.line.lastKey().length();
        if (l > n) {
            return vals;
        }
        BitSet start = new BitSet(n);
        BitSet end = new BitSet(n);
        start.or(key);
        start.set(l - 1);
        end.set(n);
        for (LatticeElement val : this.line.subMap(start, end).values()) {
            BitSet x = val.getBitMask();
            if (this.superset(x, key) < 0) continue;
            vals.add(val.getValue());
        }
        start.clear(l - 1);
        return vals;
    }

    protected abstract Collection<H> parentValues(J var1);

    @Override
    public Collection<H> parents(H x) {
        J node = this.getNode(x);
        return this.parentValues(node);
    }

    @Override
    public Collection<H> parents(BitSet x) {
        J node = this.getNodeByKey(x);
        return this.parentValues(node);
    }

    @Override
    public Collection<H> upperBorder(BitSet key) {
        return this.lcs(key, true);
    }

    @Override
    public Collection<H> immediateParents(BitSet key) {
        return this.lcs(key, false);
    }

    public boolean isEmpty() {
        return this.line.isEmpty();
    }

    public void clear() {
        this.line.clear();
    }

    protected void add(J node) {
        this.line.put(node.getBitMask(), node);
    }

    protected Collection<J> getNodes() {
        return this.line.values();
    }

    @Override
    public H getMember(BitSet key) {
        return this.line.containsKey(key) ? (H)((LatticeElement)this.line.get(key)).getValue() : null;
    }

    protected static class HierCodeComparator
    implements Comparator<BitSet>,
    Externalizable {
        @Override
        public int compare(BitSet bitMask, BitSet yset) {
            int lx = bitMask.length();
            int ly = yset.length();
            if (lx == 0 && ly == 0) {
                return 0;
            }
            if (lx > ly) {
                return 1;
            }
            if (ly > lx) {
                return -1;
            }
            BitSet x = new BitSet(ly);
            x.or(yset);
            x.xor(bitMask);
            if (x.isEmpty()) {
                return 0;
            }
            int ix = x.length() - 1;
            if (bitMask.get(ix)) {
                return 1;
            }
            if (yset.get(ix)) {
                return -1;
            }
            return 0;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        }
    }
}

