/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitType;
import org.drools.core.factmodel.traits.TraitUtils;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.drools.traits.core.factmodel.TraitProxyImpl;
import org.drools.traits.core.factmodel.TraitTypeMapImpl;

public class TraitObjectTypeNode
extends ObjectTypeNode {
    private BitSet typeMask;

    public TraitObjectTypeNode() {
    }

    public TraitObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, source, objectType, context);
        this.typeMask = context.getKnowledgeBase().getConfiguration().getComponentFactory().getTraitRegistry().getHierarchy().getCode((Object)((ClassObjectType)objectType).getClassName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.typeMask = (BitSet)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.typeMask);
    }

    public void propagateAssert(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.isAssertAllowed(factHandle)) {
            super.propagateAssert(factHandle, context, workingMemory);
        }
    }

    private boolean isAssertAllowed(InternalFactHandle factHandle) {
        if (factHandle.isTraiting()) {
            boolean allowed;
            TraitProxyImpl proxy = (TraitProxyImpl)factHandle.getObject();
            BitSet vetoMask = proxy.computeInsertionVetoMask();
            boolean vetoed = vetoMask != null && !this.typeMask.isEmpty() && TraitUtils.supersetOrEqualset((BitSet)vetoMask, (BitSet)this.typeMask);
            boolean bl = allowed = !vetoed || this.sameAndNotCoveredByDescendants((TraitProxyImpl)factHandle.getObject(), this.typeMask);
            if (allowed) {
                proxy.assignOtn(this.typeMask);
            }
            return allowed;
        }
        return true;
    }

    private boolean sameAndNotCoveredByDescendants(TraitProxyImpl proxy, BitSet typeMask) {
        boolean isSameType = typeMask.equals(proxy._getTypeCode());
        if (isSameType) {
            TraitTypeMapImpl ttm = (TraitTypeMapImpl)proxy.getObject()._getTraitMap();
            Collection descs = ttm.lowerDescendants(typeMask);
            if (descs == null || descs.isEmpty()) {
                return true;
            }
            for (Thing sub : descs) {
                TraitType tt = (TraitType)sub;
                if (tt == proxy || !tt._hasTypeCode(typeMask)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isModifyAllowed(InternalFactHandle factHandle) {
        if (factHandle.isTraiting()) {
            TraitProxyImpl proxy = (TraitProxyImpl)factHandle.getObject();
            return proxy.listAssignedOtnTypeCodes().contains(this.typeMask);
        }
        return true;
    }

    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (!this.isModifyAllowed(factHandle)) {
            return;
        }
        this.checkDirty();
        if (factHandle.isTraiting()) {
            if (this.isModifyAllowed(factHandle)) {
                this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
            }
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, !context.getModificationMask().isSet(0) ? context.adaptModificationMaskForObjectType(this.objectType, workingMemory) : context, workingMemory);
        }
    }

    public BitMask updateMask(BitMask mask) {
        BitMask returnMask = this.declaredMask.clone().setAll(mask);
        this.inferredMask = this.inferredMask.setAll(returnMask);
        return returnMask;
    }

    public BitSet getLocalTypeCode() {
        return this.typeMask;
    }
}

