/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.rule.EntryPointId;
import org.drools.core.spi.Activation;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;
import org.drools.kiesession.consequence.DefaultKnowledgeHelper;
import org.drools.kiesession.entrypoints.NamedEntryPoint;
import org.drools.tms.LogicalDependency;
import org.drools.tms.SimpleMode;
import org.drools.tms.TruthMaintenanceSystemEqualityKey;
import org.drools.tms.TruthMaintenanceSystemImpl;
import org.drools.tms.agenda.TruthMaintenanceSystemActivation;
import org.drools.tms.agenda.TruthMaintenanceSystemAgendaItem;
import org.drools.tms.beliefsystem.BeliefSet;
import org.drools.tms.beliefsystem.BeliefSystem;
import org.drools.tms.beliefsystem.BeliefSystemMode;
import org.drools.tms.beliefsystem.ModedAssertion;
import org.drools.tms.beliefsystem.simple.SimpleLogicalDependency;
import org.kie.api.runtime.rule.Match;

public class TruthMaintenanceSystemKnowledgeHelper<T extends ModedAssertion<T>>
extends DefaultKnowledgeHelper {
    private LinkedList<LogicalDependency<T>> previousJustified;
    private LinkedList<LogicalDependency<SimpleMode>> previousBlocked;

    public TruthMaintenanceSystemKnowledgeHelper() {
    }

    public TruthMaintenanceSystemKnowledgeHelper(ReteEvaluator reteEvaluator) {
        super(reteEvaluator);
    }

    public void setActivation(Activation agendaItem) {
        TruthMaintenanceSystemActivation tmsActivation = (TruthMaintenanceSystemActivation)agendaItem;
        this.previousJustified = tmsActivation.getLogicalDependencies();
        this.previousBlocked = tmsActivation.getBlocked();
        super.setActivation(agendaItem);
        tmsActivation.setLogicalDependencies(null);
        tmsActivation.setBlocked(null);
    }

    public void reset() {
        this.cancelRemainingPreviousLogicalDependencies();
        super.reset();
        this.previousJustified = null;
        this.previousBlocked = null;
    }

    public InternalFactHandle insertLogical(Object object, Object value) {
        if (object == null) {
            return null;
        }
        if (!this.activation.isMatched()) {
            return null;
        }
        LogicalDependency dep = null;
        if (this.previousJustified != null) {
            for (dep = (LogicalDependency)this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (!object.equals(((BeliefSet)dep.getJustified()).getFactHandle().getObject())) continue;
                this.previousJustified.remove((LinkedListNode)dep);
                break;
            }
        }
        if (dep != null) {
            ((TruthMaintenanceSystemActivation)this.activation).addLogicalDependency(dep);
            return ((BeliefSet)dep.getJustified()).getFactHandle();
        }
        return TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.toStatefulKnowledgeSession()).insert(object, value, this.activation);
    }

    public void cancelRemainingPreviousLogicalDependencies() {
        LogicalDependency dep;
        if (this.previousJustified != null) {
            for (dep = (LogicalDependency)this.previousJustified.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                TruthMaintenanceSystemImpl.removeLogicalDependency(dep, this.activation.getPropagationContext());
            }
        }
        if (this.previousBlocked != null) {
            dep = (LogicalDependency)this.previousBlocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.previousBlocked.remove((LinkedListNode)dep);
                TruthMaintenanceSystemAgendaItem justified = (TruthMaintenanceSystemAgendaItem)dep.getJustified();
                justified.getBlockers().remove(dep.getMode());
                if (justified.getBlockers().isEmpty()) {
                    RuleAgendaItem ruleAgendaItem = justified.getRuleAgendaItem();
                    this.toStatefulKnowledgeSession().getAgenda().stageLeftTuple(ruleAgendaItem, (AgendaItem)justified);
                }
                dep = tmp;
            }
        }
    }

    public InternalFactHandle bolster(Object object, Object value) {
        BeliefSystem beliefSystem;
        if (object == null || !this.activation.isMatched()) {
            return null;
        }
        InternalFactHandle handle = this.getFactHandleFromWM(object);
        NamedEntryPoint ep = (NamedEntryPoint)this.reteEvaluator.getEntryPoint(EntryPointId.DEFAULT.getEntryPointId());
        ObjectTypeConf otc = ep.getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(ep.getEntryPoint(), object);
        BeliefSet beliefSet = null;
        if (handle == null) {
            handle = RuntimeComponentFactory.get().getFactHandleFactoryService().newFactHandle(object, otc, this.reteEvaluator, (WorkingMemoryEntryPoint)ep);
        }
        if (handle.getEqualityKey() == null) {
            handle.setEqualityKey((EqualityKey)new TruthMaintenanceSystemEqualityKey(handle, 1));
        } else {
            beliefSet = ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).getBeliefSet();
        }
        BeliefSystem beliefSystem2 = beliefSystem = value instanceof BeliefSystemMode ? ((BeliefSystemMode)value).getBeliefSystem() : ((TruthMaintenanceSystemImpl)TruthMaintenanceSystemFactory.get().getOrCreateTruthMaintenanceSystem((ReteEvaluator)this.toStatefulKnowledgeSession())).getBeliefSystem();
        if (beliefSet == null) {
            beliefSet = beliefSystem.newBeliefSet(handle);
            ((TruthMaintenanceSystemEqualityKey)handle.getEqualityKey()).setBeliefSet(beliefSet);
        }
        return beliefSystem.insert(beliefSystem.asMode(value), this.activation.getRule(), (TruthMaintenanceSystemActivation)this.activation, object, beliefSet, this.activation.getPropagationContext(), otc).getFactHandle();
    }

    public void blockMatch(Match act) {
        TruthMaintenanceSystemAgendaItem targetMatch = (TruthMaintenanceSystemAgendaItem)act;
        SimpleLogicalDependency<SimpleMode> dep = null;
        if (this.previousBlocked != null) {
            for (dep = (SimpleLogicalDependency<SimpleMode>)this.previousBlocked.getFirst(); dep != null; dep = (LogicalDependency)dep.getNext()) {
                if (targetMatch != dep.getJustified()) continue;
                this.previousBlocked.remove((LinkedListNode)dep);
                break;
            }
        }
        if (dep == null) {
            SimpleMode mode = new SimpleMode();
            dep = new SimpleLogicalDependency<SimpleMode>((TruthMaintenanceSystemActivation)this.activation, targetMatch, mode);
            mode.setObject(dep);
        }
        ((TruthMaintenanceSystemActivation)this.activation).addBlocked((LogicalDependency<SimpleMode>)dep);
        if (targetMatch.getBlockers().size() == 1 && targetMatch.isQueued()) {
            if (targetMatch.getRuleAgendaItem() == null) {
                targetMatch.remove();
            } else {
                targetMatch.getRuleAgendaItem().getRuleExecutor().removeLeftTuple(targetMatch.getTuple());
            }
            if (targetMatch.getActivationGroupNode() != null) {
                targetMatch.getActivationGroupNode().getActivationGroup().removeActivation((Activation)targetMatch);
            }
            if (targetMatch.getActivationNode() != null) {
                InternalRuleFlowGroup ruleFlowGroup = (InternalRuleFlowGroup)targetMatch.getActivationNode().getParentContainer();
                ruleFlowGroup.remove((Activation)targetMatch);
            }
        }
    }

    public void unblockAllMatches(Match act) {
        TruthMaintenanceSystemAgendaItem targetMatch = (TruthMaintenanceSystemAgendaItem)act;
        boolean wasBlocked = targetMatch.getBlockers() != null && !targetMatch.getBlockers().isEmpty();
        LinkedListEntry entry = (LinkedListEntry)targetMatch.getBlockers().getFirst();
        while (entry != null) {
            LinkedListEntry tmp = (LinkedListEntry)entry.getNext();
            LogicalDependency dep = (LogicalDependency)entry.getObject();
            ((TruthMaintenanceSystemAgendaItem)dep.getJustifier()).removeBlocked(dep);
            entry = tmp;
        }
        if (wasBlocked) {
            RuleAgendaItem ruleAgendaItem = targetMatch.getRuleAgendaItem();
            InternalAgenda agenda = this.toStatefulKnowledgeSession().getAgenda();
            agenda.stageLeftTuple(ruleAgendaItem, (AgendaItem)targetMatch);
        }
    }
}

