/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;

public class JavaSerializableResolverStrategy
implements ObjectMarshallingStrategy {
    private ObjectMarshallingStrategyAcceptor acceptor;

    public JavaSerializableResolverStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        return os.readObject();
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        os.writeObject(object);
    }

    public boolean accept(Object object) {
        return this.acceptor.accept(object);
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) {
        byte[] byArray;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            os = new ObjectOutputStream(bs);
            this.write(os, object);
            byArray = bs.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bs.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        bs.close();
        return byArray;
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, final ClassLoader classloader) {
        Object object2;
        ByteArrayInputStream bs = new ByteArrayInputStream(object);
        try {
            is = new ObjectInputStream(bs){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    return Class.forName(desc.getName(), true, classloader);
                }
            };
            object2 = this.read(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bs.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        bs.close();
        return object2;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }

    public String toString() {
        return "JavaSerializableResolverStrategy{acceptor=" + this.acceptor + '}';
    }
}

