/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.compiler.profiles.ExtendedDMNProfile;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.extended.CodeFunction;
import org.kie.dmn.feel.util.Either;

public class DMNFeelExpressionEvaluator
extends AbstractExpressionEvaluator {
    private final ClassLoader classLoader;
    private final CodeFunction codeFunction = new CodeFunction();

    public DMNFeelExpressionEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String fromObjectToExpression(Object value) {
        FEELFnResult invoke = this.codeFunction.invoke(value);
        return (String)invoke.getOrElseThrow(feelEvent -> new IllegalArgumentException("This should not happen", feelEvent.getSourceException()));
    }

    protected FEEL newFeelEvaluator(AtomicReference<FEELEvent> errorHolder) {
        errorHolder.set(null);
        FEEL feel = FEEL.newInstance(Collections.singletonList(new ExtendedDMNProfile()));
        feel.addListener(event -> {
            FEELEvent feelEvent = (FEELEvent)errorHolder.get();
            if (!(feelEvent instanceof SyntaxErrorEvent) && FEELEvent.Severity.ERROR.equals((Object)event.getSeverity())) {
                errorHolder.set(event);
            }
        });
        return feel;
    }

    @Override
    protected Object internalLiteralEvaluation(String raw, String className) {
        return this.executeAndVerifyErrors(feel -> feel.evaluate(raw));
    }

    @Override
    protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
        if (rawExpression != null && skipEmptyString && rawExpression.isEmpty()) {
            return true;
        }
        Either<List<FEELEvent>, Boolean> utCommandResult = this.executeAndVerifyErrors(new EvaluateUTCommand(rawExpression, resultValue));
        return (Boolean)utCommandResult.getOrElseThrow(l -> new IllegalArgumentException("Error during evaluation: " + l.stream().map(FEELEvent::getMessage).collect(Collectors.joining(", "))));
    }

    protected <T> T executeAndVerifyErrors(Function<FEEL, T> command) {
        AtomicReference<FEELEvent> errorHolder = new AtomicReference<FEELEvent>();
        FEEL feel = this.newFeelEvaluator(errorHolder);
        T result = command.apply(feel);
        FEELEvent errorEvent = errorHolder.get();
        if (errorEvent != null) {
            if (errorEvent instanceof SyntaxErrorEvent) {
                throw new IllegalArgumentException("Syntax error: " + errorEvent.getMessage());
            }
            throw new IllegalArgumentException("Error during evaluation: " + errorEvent.getMessage());
        }
        return result;
    }

    @Override
    protected Object extractFieldValue(Object result, String fieldName) {
        return ((Map)result).get(fieldName);
    }

    @Override
    protected Object createObject(String className, List<String> genericClasses) {
        return new HashMap();
    }

    @Override
    protected void setField(Object toReturn, String fieldName, Object fieldValue) {
        Map returnMap = (Map)toReturn;
        returnMap.put(fieldName, fieldValue);
    }

    @Override
    protected boolean isStructuredResult(Class<?> resultClass) {
        return resultClass != null && ScenarioSimulationSharedUtils.isList((String)resultClass.getCanonicalName());
    }

    @Override
    protected boolean isStructuredInput(String className) {
        return ScenarioSimulationSharedUtils.isList((String)className);
    }

    @Override
    protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
        return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
    }

    private static class EvaluateUTCommand
    implements Function<FEEL, Either<List<FEELEvent>, Boolean>> {
        private final String rawExpression;
        private final Object resultValue;

        public EvaluateUTCommand(String rawExpression, Object resultValue) {
            this.rawExpression = rawExpression;
            this.resultValue = resultValue;
        }

        @Override
        public Either<List<FEELEvent>, Boolean> apply(FEEL feel) {
            List unaryTests = feel.evaluateUnaryTests(this.rawExpression, Collections.singletonMap("?", BuiltInType.UNKNOWN));
            ArrayList utEvalErrors = new ArrayList();
            FEELEventListener utErrorListener = errorEvent -> utEvalErrors.add(errorEvent);
            EvaluationContextImpl evaluationContext = ((FEELImpl)feel).newEvaluationContext(List.of(utErrorListener), Collections.singletonMap("?", this.resultValue));
            boolean allMatch = unaryTests.stream().allMatch(arg_0 -> this.lambda$apply$1((EvaluationContext)evaluationContext, arg_0));
            if (utEvalErrors.isEmpty()) {
                return Either.ofRight((Object)allMatch);
            }
            return Either.ofLeft(utEvalErrors);
        }

        private /* synthetic */ boolean lambda$apply$1(EvaluationContext evaluationContext, UnaryTest unaryTest) {
            return Optional.ofNullable((Boolean)unaryTest.apply((Object)evaluationContext, this.resultValue)).orElse(false);
        }
    }
}

