/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExpressionEvaluatorResult {
    private boolean successful;
    private String wrongValue;
    private List<String> pathToWrongValue;

    public static ExpressionEvaluatorResult of(boolean successful) {
        return new ExpressionEvaluatorResult(successful);
    }

    public static ExpressionEvaluatorResult ofSuccessful() {
        return new ExpressionEvaluatorResult(true);
    }

    public static ExpressionEvaluatorResult ofFailed() {
        return new ExpressionEvaluatorResult(false);
    }

    public static ExpressionEvaluatorResult ofFailed(String wrongValue, String wrongValueField) {
        return new ExpressionEvaluatorResult(false, wrongValue, wrongValueField);
    }

    private ExpressionEvaluatorResult(boolean successful, String wrongValue, String wrongValueField) {
        this.successful = successful;
        this.pathToWrongValue = new ArrayList<String>();
        this.addFieldItemStepToPath(wrongValueField);
        this.wrongValue = wrongValue;
    }

    private ExpressionEvaluatorResult(boolean successful) {
        this.successful = successful;
        this.pathToWrongValue = new ArrayList<String>();
        this.wrongValue = null;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void addFieldItemStepToPath(String fieldName) {
        this.pathToWrongValue.add(0, fieldName);
    }

    public void addListItemStepToPath(int elementNumber) {
        this.pathToWrongValue.add(0, "Item #: " + elementNumber);
    }

    public void addMapItemStepToPath(String key) {
        this.pathToWrongValue.add(0, "Item key \"" + key + "\"");
    }

    public void setWrongValue(String wrongValue) {
        this.wrongValue = wrongValue;
    }

    public String getWrongValue() {
        return this.wrongValue;
    }

    public List<String> getPathToWrongValue() {
        return Collections.unmodifiableList(this.pathToWrongValue);
    }
}

