/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;

public class ScenarioResultMetadata {
    protected final Set<String> available = new HashSet<String>();
    protected final Map<String, Integer> executed = new HashMap<String, Integer>();
    protected final List<AuditLogLine> auditLogLines = new ArrayList<AuditLogLine>();
    protected final ScenarioWithIndex scenarioWithIndex;

    public ScenarioResultMetadata(ScenarioWithIndex scenarioWithIndex) {
        this.scenarioWithIndex = scenarioWithIndex;
    }

    public void addAvailable(String element) {
        this.available.add(element);
    }

    public void addAllAvailable(Set<String> elements) {
        this.available.addAll(elements);
    }

    public void addExecuted(String element) {
        this.executed.compute(element, (key, value) -> value == null ? 1 : value + 1);
    }

    public void addAllExecuted(Map<String, Integer> elements) {
        this.executed.putAll(elements);
    }

    public void addAuditMessage(int messageIndex, String message, String severity) {
        this.auditLogLines.add(new AuditLogLine(this.scenarioWithIndex.getIndex(), ((Scenario)this.scenarioWithIndex.getScesimData()).getDescription(), messageIndex, message, severity));
    }

    public void addAuditLogLines(List<AuditLogLine> toAdd) {
        this.auditLogLines.addAll(toAdd);
    }

    public Set<String> getAvailable() {
        return Collections.unmodifiableSet(this.available);
    }

    public Set<String> getExecuted() {
        return Collections.unmodifiableSet(this.executed.keySet());
    }

    public Map<String, Integer> getExecutedWithCounter() {
        return Collections.unmodifiableMap(this.executed);
    }

    public List<AuditLogLine> getAuditLogLines() {
        return Collections.unmodifiableList(this.auditLogLines);
    }

    public ScenarioWithIndex getScenarioWithIndex() {
        return this.scenarioWithIndex;
    }
}

