/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.scenariosimulation.backend.expression.AbstractExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.BaseExpressionOperator;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;

public class BaseExpressionEvaluator
extends AbstractExpressionEvaluator {
    private final ClassLoader classLoader;

    public BaseExpressionEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean evaluateUnaryExpression(Object raw, Object resultValue, Class<?> resultClass) {
        if (!(raw instanceof String)) {
            return BaseExpressionOperator.EQUALS.eval(raw, resultValue, resultClass, this.classLoader);
        }
        return this.commonEvaluateUnaryExpression(raw, resultValue, resultClass);
    }

    @Override
    public Object evaluateLiteralExpression(String className, List<String> genericClasses, Object rawExpression) {
        if (!(rawExpression instanceof String)) {
            return rawExpression;
        }
        return this.commonEvaluationLiteralExpression(className, genericClasses, (String)rawExpression);
    }

    @Override
    public String fromObjectToExpression(Object value) {
        return ScenarioBeanUtil.revertValue(value);
    }

    @Override
    protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
        if (rawExpression != null && skipEmptyString && rawExpression.isEmpty()) {
            return true;
        }
        if (resultClass == null) {
            return rawExpression == null || rawExpression.isEmpty();
        }
        return BaseExpressionOperator.findOperator(rawExpression).eval(rawExpression, resultValue, resultClass, this.classLoader);
    }

    @Override
    protected Object internalLiteralEvaluation(String rawValue, String className) {
        return BaseExpressionOperator.findOperator(rawValue).evaluateLiteralExpression(className, rawValue, this.classLoader);
    }

    @Override
    protected Object extractFieldValue(Object result, String fieldName) {
        try {
            if (result instanceof Map) {
                return ((Map)result).get(fieldName);
            }
            Field declaredField = ScenarioBeanUtil.getField(result.getClass(), fieldName);
            declaredField.setAccessible(true);
            return declaredField.get(result);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Impossible to find field: " + fieldName, e);
        }
    }

    @Override
    protected Object createObject(String className, List<String> genericClasses) {
        if (ScenarioSimulationSharedUtils.isMap((String)className)) {
            return new HashMap();
        }
        try {
            return this.classLoader.loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Impossible to instantiate " + className, e);
        }
    }

    @Override
    protected void setField(Object toReturn, String fieldName, Object fieldValue) {
        if (toReturn instanceof Map) {
            Map returnMap = (Map)toReturn;
            returnMap.put(fieldName, fieldValue);
        } else {
            try {
                Field declaredField = ScenarioBeanUtil.getField(toReturn.getClass(), fieldName);
                declaredField.setAccessible(true);
                declaredField.set(toReturn, fieldValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Impossible to set the field " + fieldName, e);
            }
        }
    }

    @Override
    protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
        try {
            if (ScenarioSimulationSharedUtils.isMap((String)className)) {
                return new AbstractMap.SimpleEntry<String, List<String>>(genericClasses.get(genericClasses.size() - 1), Collections.emptyList());
            }
            Field declaredField = ScenarioBeanUtil.getField(element.getClass(), fieldName);
            Class<?> fieldType = declaredField.getType();
            ArrayList<String> genericsString = new ArrayList<String>();
            if (declaredField.getGenericType() instanceof ParameterizedType) {
                ParameterizedType generics = (ParameterizedType)declaredField.getGenericType();
                for (Type typeArgument : generics.getActualTypeArguments()) {
                    if (typeArgument instanceof ParameterizedType) {
                        genericsString.add(((ParameterizedType)typeArgument).getRawType().getTypeName());
                        continue;
                    }
                    genericsString.add(typeArgument.getTypeName());
                }
            }
            return new AbstractMap.SimpleEntry<String, List<String>>(fieldType.getCanonicalName(), genericsString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Impossible to get the field " + fieldName, e);
        }
    }
}

