/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.DMNScenarioRunner;
import org.drools.scenariosimulation.backend.runner.IndexedScenarioException;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.ScenarioRunnerProvider;
import org.drools.scenariosimulation.backend.runner.SimulationRunMetadataBuilder;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;

public abstract class AbstractScenarioRunner
extends Runner {
    protected final ClassLoader classLoader;
    protected final Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory;
    protected final Description desc;
    protected final KieContainer kieContainer;
    protected final SimulationDescriptor simulationDescriptor;
    protected List<ScenarioWithIndex> scenarios;
    protected String fileName;
    protected SimulationRunMetadataBuilder simulationRunMetadataBuilder;

    public AbstractScenarioRunner(KieContainer kieContainer, Simulation simulation, String fileName, Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory) {
        this(kieContainer, simulation.getSimulationDescriptor(), simulation.getScenarioWithIndex(), fileName, expressionEvaluatorFactory);
    }

    public AbstractScenarioRunner(KieContainer kieContainer, SimulationDescriptor simulationDescriptor, List<ScenarioWithIndex> scenarios, String fileName, Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory) {
        this.kieContainer = kieContainer;
        this.simulationDescriptor = simulationDescriptor;
        this.scenarios = scenarios;
        this.fileName = fileName;
        this.desc = AbstractScenarioRunner.getDescriptionForSimulation(this.getFileName(), simulationDescriptor, scenarios);
        this.classLoader = kieContainer.getClassLoader();
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    public void run(RunNotifier notifier) {
        this.simulationRunMetadataBuilder = SimulationRunMetadataBuilder.create();
        notifier.fireTestStarted(this.getDescription());
        for (ScenarioWithIndex scenarioWithIndex : this.scenarios) {
            this.singleRunScenario(scenarioWithIndex, notifier).ifPresent(this.simulationRunMetadataBuilder::addScenarioResultMetadata);
        }
        notifier.fireTestStarted(this.getDescription());
    }

    public Description getDescription() {
        return this.desc;
    }

    protected Optional<ScenarioResultMetadata> singleRunScenario(ScenarioWithIndex scenarioWithIndex, RunNotifier runNotifier) {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        int index = scenarioWithIndex.getIndex();
        Description descriptionForScenario = AbstractScenarioRunner.getDescriptionForScenario(this.getFileName(), index, scenarioWithIndex.getScenario());
        runNotifier.fireTestStarted(descriptionForScenario);
        try {
            this.internalRunScenario(scenarioWithIndex, scenarioRunnerData);
        }
        catch (ScenarioException e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, (Throwable)e);
            indexedScenarioException.setFileName(this.fileName);
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, (Throwable)indexedScenarioException));
        }
        catch (Throwable e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, "Unexpected test error in scenario '" + scenarioWithIndex.getScenario().getDescription() + "'", e);
            indexedScenarioException.setFileName(this.fileName);
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, (Throwable)indexedScenarioException));
        }
        runNotifier.fireTestFinished(descriptionForScenario);
        return scenarioRunnerData.getMetadata();
    }

    protected void internalRunScenario(ScenarioWithIndex scenarioWithIndex, ScenarioRunnerData scenarioRunnerData) {
        ExpressionEvaluator expressionEvaluator = this.createExpressionEvaluator();
        this.newRunnerHelper(this.getSimulationDescriptor()).run(this.getKieContainer(), this.getSimulationDescriptor(), scenarioWithIndex, expressionEvaluator, this.getClassLoader(), scenarioRunnerData);
    }

    public ExpressionEvaluator createExpressionEvaluator() {
        return this.expressionEvaluatorFactory.apply(this.classLoader);
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public SimulationDescriptor getSimulationDescriptor() {
        return this.simulationDescriptor;
    }

    public Optional<SimulationRunMetadata> getLastRunResultMetadata() {
        return this.simulationRunMetadataBuilder != null ? Optional.of(this.simulationRunMetadataBuilder.build()) : Optional.empty();
    }

    public static Description getDescriptionForSimulation(Optional<String> filename, Simulation simulation) {
        return AbstractScenarioRunner.getDescriptionForSimulation(filename, simulation.getSimulationDescriptor(), simulation.getScenarioWithIndex());
    }

    public static Description getDescriptionForSimulation(Optional<String> filename, SimulationDescriptor simulationDescriptor, List<ScenarioWithIndex> scenarios) {
        Description suiteDescription = Description.createSuiteDescription((String)"Test Scenarios (Preview) tests", (Annotation[])new Annotation[0]);
        scenarios.forEach(scenarioWithIndex -> suiteDescription.addChild(AbstractScenarioRunner.getDescriptionForScenario(filename, scenarioWithIndex.getIndex(), scenarioWithIndex.getScenario())));
        return suiteDescription;
    }

    public static Description getDescriptionForScenario(Optional<String> className, int index, Scenario scenario) {
        return Description.createTestDescription((String)className.orElse(AbstractScenarioRunner.class.getCanonicalName()), (String)String.format("#%d: %s", index, scenario.getDescription()), (Annotation[])new Annotation[0]);
    }

    public static ScenarioRunnerProvider getSpecificRunnerProvider(SimulationDescriptor simulationDescriptor) {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)simulationDescriptor.getType())) {
            return RuleScenarioRunner::new;
        }
        if (ScenarioSimulationModel.Type.DMN.equals((Object)simulationDescriptor.getType())) {
            return DMNScenarioRunner::new;
        }
        throw new IllegalArgumentException("Impossible to run simulation of type " + simulationDescriptor.getType());
    }

    protected abstract AbstractRunnerHelper newRunnerHelper(SimulationDescriptor var1);
}

