/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.ClockTypeOption;

public class RuleStatelessScenarioExecutableBuilder
implements RuleScenarioExecutableBuilder {
    private final KieContainer kieContainer;
    private final String sessionName;
    private final List<Object> inputs = new ArrayList<Object>();
    private final Map<FactIdentifier, List<FactCheckerHandle>> internalConditions = new HashMap<FactIdentifier, List<FactCheckerHandle>>();
    private final KieCommands commands = KieServices.get().getCommands();
    private String agendaGroup;

    protected RuleStatelessScenarioExecutableBuilder(KieContainer kieContainer, String sessionName) {
        this.kieContainer = kieContainer;
        this.sessionName = sessionName;
    }

    @Override
    public void addInternalCondition(Class<?> clazz, Function<Object, ResultWrapper> checkFunction, ScenarioResult scenarioResult) {
        this.internalConditions.computeIfAbsent(scenarioResult.getFactIdentifier(), key -> new ArrayList()).add(new FactCheckerHandle(clazz, checkFunction, scenarioResult));
    }

    @Override
    public void setActiveAgendaGroup(String agendaGroup) {
        this.agendaGroup = agendaGroup;
    }

    @Override
    public void setActiveRuleFlowGroup(String ruleFlowGroup) {
        this.agendaGroup = ruleFlowGroup;
    }

    @Override
    public void insert(Object element) {
        this.inputs.add(element);
    }

    @Override
    public RequestContext run() {
        KieSessionModel kieSessionModel = this.kieContainer.getKieSessionModel(this.sessionName);
        if (kieSessionModel == null) {
            throw new ScenarioException("Impossible to find a KieSession with name " + this.sessionName);
        }
        kieSessionModel.setClockType(ClockTypeOption.get((String)"pseudo"));
        StatelessKieSession statelessKieSession = this.kieContainer.newStatelessKieSession(this.sessionName);
        statelessKieSession.execute(this.generateCommands());
        return null;
    }

    protected Command<ExecutionResults> generateCommands() {
        ArrayList<Command> toReturn = new ArrayList<Command>();
        if (this.agendaGroup != null) {
            toReturn.add(this.commands.newAgendaGroupSetFocus(this.agendaGroup));
        }
        if (!this.inputs.isEmpty()) {
            toReturn.add(this.commands.newInsertElements(this.inputs));
        }
        toReturn.add(this.commands.newFireAllRules());
        this.internalConditions.values().forEach(factToCheck -> toReturn.add((Command)new ValidateFactCommand((List<FactCheckerHandle>)factToCheck)));
        return this.commands.newBatchExecution(toReturn);
    }
}

