/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.backend.fluent.FactCheckerHandle;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.fluent.ValidateFactCommand;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.builder.fluent.ExecutableBuilder;
import org.kie.internal.builder.fluent.KieSessionFluent;

public class RuleStatefulScenarioExecutableBuilder
implements RuleScenarioExecutableBuilder {
    private final KieSessionFluent kieSessionFluent;
    private final ExecutableBuilder executableBuilder;
    private final Map<FactIdentifier, List<FactCheckerHandle>> internalConditions = new HashMap<FactIdentifier, List<FactCheckerHandle>>();
    private static final String DEFAULT_APPLICATION = "defaultApplication";
    protected static final BiFunction<String, KieContainer, KieContainer> forcePseudoClock = (sessionName, kc) -> {
        KieSessionModel kieSessionModel = kc.getKieSessionModel(sessionName);
        if (kieSessionModel == null) {
            throw new ScenarioException("Impossible to find a KieSession with name " + sessionName);
        }
        kieSessionModel.setClockType(ClockTypeOption.get((String)"pseudo"));
        return kc;
    };

    protected RuleStatefulScenarioExecutableBuilder(KieContainer kieContainer, String kieSessionName) {
        this.executableBuilder = this.createExecutableBuilder();
        this.kieSessionFluent = ((ExecutableBuilder)this.executableBuilder.newApplicationContext(DEFAULT_APPLICATION)).setKieContainer(kieContainer).newSessionCustomized(kieSessionName, forcePseudoClock);
    }

    protected RuleStatefulScenarioExecutableBuilder(KieContainer kieContainer) {
        this(kieContainer, null);
    }

    @Override
    public void addInternalCondition(Class<?> clazz, Function<Object, ResultWrapper> checkFunction, ScenarioResult scenarioResult) {
        this.internalConditions.computeIfAbsent(scenarioResult.getFactIdentifier(), key -> new ArrayList()).add(new FactCheckerHandle(clazz, checkFunction, scenarioResult));
    }

    @Override
    public void setActiveAgendaGroup(String agendaGroup) {
        this.kieSessionFluent.setActiveAgendaGroup(agendaGroup);
    }

    @Override
    public void setActiveRuleFlowGroup(String ruleFlowGroup) {
        this.kieSessionFluent.setActiveRuleFlowGroup(ruleFlowGroup);
    }

    @Override
    public void insert(Object element) {
        this.kieSessionFluent.insert(element);
    }

    @Override
    public RequestContext run() {
        Objects.requireNonNull(this.executableBuilder, "Executable builder is null, please invoke create(KieContainer, )");
        this.kieSessionFluent.fireAllRules();
        this.internalConditions.values().forEach(factToCheck -> {
            KieSessionFluent cfr_ignored_0 = (KieSessionFluent)this.kieSessionFluent.addCommand((ExecutableCommand)new ValidateFactCommand((List<FactCheckerHandle>)factToCheck));
        });
        ((ExecutableBuilder)this.kieSessionFluent.dispose()).end();
        return (RequestContext)this.createExecutableRunner().execute(this.executableBuilder.getExecutable());
    }

    protected ExecutableBuilder createExecutableBuilder() {
        return ExecutableBuilder.create();
    }

    protected ExecutableRunner<RequestContext> createExecutableRunner() {
        return ExecutableRunner.create();
    }
}

