/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.function.Function;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.util.MigrationStrategy;
import org.drools.scenariosimulation.backend.util.ScenarioSimulationXMLPersistence;

public class InMemoryMigrationStrategy
implements MigrationStrategy {
    @Override
    public Function<String, String> from1_0to1_1() {
        return rawXml -> rawXml.replaceAll("EXPECTED", "EXPECT").replaceAll("<ScenarioSimulationModel version=\"1.0\">", "<ScenarioSimulationModel version=\"1.1\">");
    }

    @Override
    public Function<String, String> from1_1to1_2() {
        return rawXml -> {
            if (rawXml.contains("<dmoSession>") || rawXml.contains("<dmnFilePath>") && rawXml.contains("<type>")) {
                return rawXml.replaceAll("<ScenarioSimulationModel version=\"1.1\">", "<ScenarioSimulationModel version=\"1.2\">");
            }
            return rawXml.replaceAll("</simulationDescriptor>", "<dmoSession></dmoSession>\n<type>RULE</type>\n</simulationDescriptor>").replaceAll("<ScenarioSimulationModel version=\"1.1\">", "<ScenarioSimulationModel version=\"1.2\">");
        };
    }

    @Override
    public Function<String, String> from1_2to1_3() {
        return rawXml -> {
            ScenarioSimulationXMLPersistence xmlPersistence = ScenarioSimulationXMLPersistence.getInstance();
            ScenarioSimulationModel model = xmlPersistence.unmarshal((String)rawXml, false);
            for (FactMapping factMapping : model.getSimulation().getSimulationDescriptor().getUnmodifiableFactMappings()) {
                factMapping.getExpressionElements().add(0, new ExpressionElement(factMapping.getFactIdentifier().getName()));
            }
            return xmlPersistence.marshal(model).replaceAll("<ScenarioSimulationModel version=\"1.2\">", "<ScenarioSimulationModel version=\"1.3\">");
        };
    }

    @Override
    public Function<String, String> from1_3to1_4() {
        return rawXml -> {
            if (rawXml.contains("<type>")) {
                StringBuilder replacementBuilder = new StringBuilder();
                String toReplace = null;
                if (rawXml.contains("<type>RULE</type>")) {
                    toReplace = "<type>RULE</type>";
                    if (!rawXml.contains("<kieSession>")) {
                        replacementBuilder.append("<kieSession>default</kieSession>\n");
                    }
                    if (!rawXml.contains("<kieBase>")) {
                        replacementBuilder.append("<kieBase>default</kieBase>\n");
                    }
                    if (!rawXml.contains("<ruleFlowGroup>")) {
                        replacementBuilder.append("<ruleFlowGroup>default</ruleFlowGroup>\n");
                    }
                    if (!rawXml.contains("<skipFromBuild>")) {
                        replacementBuilder.append("<skipFromBuild>false</skipFromBuild>\n");
                    }
                    replacementBuilder.append("<type>RULE</type>");
                } else if (rawXml.contains("<type>DMN</type>")) {
                    toReplace = "<type>DMN</type>";
                    if (!rawXml.contains("<dmnNamespace>")) {
                        replacementBuilder.append("<dmnNamespace></dmnNamespace>\n");
                    }
                    if (!rawXml.contains("<dmnName>")) {
                        replacementBuilder.append("<dmnName></dmnName>\n");
                    }
                    if (!rawXml.contains("<skipFromBuild>")) {
                        replacementBuilder.append("<skipFromBuild>false</skipFromBuild>\n");
                    }
                    replacementBuilder.append("<type>DMN</type>");
                }
                String toReturn = rawXml.replaceAll("<ScenarioSimulationModel version=\"1.3\">", "<ScenarioSimulationModel version=\"1.4\">").replaceAll("<simulationDescriptor>", "<simulationDescriptor>\n  <fileName></fileName>");
                String replacement = replacementBuilder.toString();
                if (toReplace != null && !toReplace.equals(replacement)) {
                    toReturn = toReturn.replaceAll(toReplace, replacement);
                }
                return toReturn;
            }
            return rawXml;
        };
    }
}

