/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner.model;

import java.util.function.Supplier;

public class ResultWrapper<T> {
    private final boolean satisfied;
    private final T result;
    private final T expected;

    private ResultWrapper(T result, boolean satisfied) {
        this.satisfied = satisfied;
        this.result = result;
        this.expected = null;
    }

    private ResultWrapper(T result, T expected) {
        this.satisfied = false;
        this.result = result;
        this.expected = expected;
    }

    public static <T> ResultWrapper<T> createResult(T result) {
        return new ResultWrapper<boolean>((boolean)result, true);
    }

    public static <T> ResultWrapper<T> createErrorResult(T result, T expected) {
        return new ResultWrapper<T>(result, expected);
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public T getResult() {
        return this.result;
    }

    public T getExpected() {
        return this.expected;
    }

    public T orElse(T defaultValue) {
        return this.satisfied ? this.result : defaultValue;
    }

    public T orElseGet(Supplier<T> defaultSupplier) {
        return this.satisfied ? this.result : defaultSupplier.get();
    }
}

