/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;

public abstract class AbstractRunnerHelper {
    public void run(KieContainer kieContainer, SimulationDescriptor simulationDescriptor, ScenarioWithIndex scenarioWithIndex, ExpressionEvaluator expressionEvaluator, ClassLoader classLoader, ScenarioRunnerData scenarioRunnerData) {
        Scenario scenario = scenarioWithIndex.getScenario();
        this.extractGivenValues(simulationDescriptor, scenario.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator).forEach(scenarioRunnerData::addGiven);
        this.extractExpectedValues(scenario.getUnmodifiableFactMappingValues()).forEach(scenarioRunnerData::addExpect);
        RequestContext requestContext = this.executeScenario(kieContainer, scenarioRunnerData, expressionEvaluator, simulationDescriptor);
        scenarioRunnerData.setMetadata(this.extractResultMetadata(requestContext, scenarioWithIndex));
        this.verifyConditions(simulationDescriptor, scenarioRunnerData, expressionEvaluator, requestContext);
        this.validateAssertion(scenarioRunnerData.getResults(), scenario);
    }

    public List<ScenarioGiven> extractGivenValues(SimulationDescriptor simulationDescriptor, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) {
        ArrayList<ScenarioGiven> scenarioGiven = new ArrayList<ScenarioGiven>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = this.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.GIVEN);
        for (Map.Entry<FactIdentifier, List<FactMappingValue>> entry : groupByFactIdentifier.entrySet()) {
            FactIdentifier factIdentifier = entry.getKey();
            Map<List<String>, Object> paramsForBean = this.getParamsForBean(simulationDescriptor, factIdentifier, entry.getValue(), expressionEvaluator);
            Object bean = this.getDirectMapping(paramsForBean).orElseGet(() -> this.createObject(factIdentifier.getClassName(), paramsForBean, classLoader));
            scenarioGiven.add(new ScenarioGiven(factIdentifier, bean));
        }
        return scenarioGiven;
    }

    public ResultWrapper<Object> getDirectMapping(Map<List<String>, Object> params) {
        for (Map.Entry<List<String>, Object> entry : params.entrySet()) {
            if (!entry.getKey().isEmpty()) continue;
            return ResultWrapper.createResult(entry.getValue());
        }
        return ResultWrapper.createErrorResult(null, null);
    }

    public List<ScenarioExpect> extractExpectedValues(List<FactMappingValue> factMappingValues) {
        ArrayList<ScenarioExpect> scenarioExpect = new ArrayList<ScenarioExpect>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = this.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.EXPECT);
        Set inputFacts = factMappingValues.stream().filter(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())).map(FactMappingValue::getFactIdentifier).collect(Collectors.toSet());
        Iterator<Map.Entry<FactIdentifier, List<FactMappingValue>>> iterator = groupByFactIdentifier.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FactIdentifier, List<FactMappingValue>> entry;
            FactIdentifier factIdentifier;
            scenarioExpect.add(new ScenarioExpect(factIdentifier, entry.getValue(), !inputFacts.contains(factIdentifier = (entry = iterator.next()).getKey())));
        }
        return scenarioExpect;
    }

    public Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifierAndFilter(List<FactMappingValue> factMappingValues, FactMappingType type) {
        HashMap<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = new HashMap<FactIdentifier, List<FactMappingValue>>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            FactIdentifier factIdentifier = factMappingValue.getFactIdentifier();
            if (factMappingValue.getRawValue() == null) continue;
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            if (expressionIdentifier == null) {
                throw new IllegalArgumentException("ExpressionIdentifier malformed");
            }
            if (!Objects.equals(expressionIdentifier.getType(), type)) continue;
            groupByFactIdentifier.computeIfAbsent(factIdentifier, key -> new ArrayList()).add(factMappingValue);
        }
        return groupByFactIdentifier;
    }

    public Map<List<String>, Object> getParamsForBean(SimulationDescriptor simulationDescriptor, FactIdentifier factIdentifier, List<FactMappingValue> factMappingValues, ExpressionEvaluator expressionEvaluator) {
        HashMap<List<String>, Object> paramsForBean = new HashMap<List<String>, Object>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List pathToField = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            try {
                Object value = expressionEvaluator.evaluateLiteralExpression(factMapping.getClassName(), factMapping.getGenericTypes(), factMappingValue.getRawValue());
                paramsForBean.put(pathToField, value);
            }
            catch (IllegalArgumentException e) {
                factMappingValue.setExceptionMessage(e.getMessage());
                throw new ScenarioException(e.getMessage(), e);
            }
        }
        return paramsForBean;
    }

    public void validateAssertion(List<ScenarioResult> scenarioResults, Scenario scenario) {
        boolean scenarioFailed = false;
        for (ScenarioResult scenarioResult : scenarioResults) {
            if (scenarioResult.getResult()) continue;
            scenarioFailed = true;
        }
        if (scenarioFailed) {
            throw new ScenarioException("Scenario '" + scenario.getDescription() + "' failed");
        }
    }

    protected ScenarioResult fillResult(FactMappingValue expectedResult, FactIdentifier factIdentifier, Supplier<ResultWrapper<?>> resultSupplier) {
        ResultWrapper<?> resultValue = resultSupplier.get();
        if (!resultValue.isSatisfied()) {
            expectedResult.setErrorValue(resultValue.getResult());
        } else {
            expectedResult.resetStatus();
        }
        return new ScenarioResult(factIdentifier, expectedResult, resultValue.getResult()).setResult(resultValue.isSatisfied());
    }

    protected ScenarioResultMetadata extractResultMetadata(RequestContext requestContext, ScenarioWithIndex scenarioWithIndex) {
        return null;
    }

    public abstract RequestContext executeScenario(KieContainer var1, ScenarioRunnerData var2, ExpressionEvaluator var3, SimulationDescriptor var4);

    public abstract void verifyConditions(SimulationDescriptor var1, ScenarioRunnerData var2, ExpressionEvaluator var3, RequestContext var4);

    public abstract Object createObject(String var1, Map<List<String>, Object> var2, ClassLoader var3);
}

