/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.factory;

import java.util.function.Function;
import org.drools.core.common.ReteEvaluator;
import org.drools.ruleunits.api.RuleUnitData;
import org.drools.ruleunits.api.RuleUnitInstance;
import org.drools.ruleunits.api.RuleUnitProvider;
import org.drools.ruleunits.api.RuleUnits;
import org.drools.ruleunits.api.conf.RuleConfig;
import org.drools.ruleunits.impl.InternalRuleUnit;
import org.drools.ruleunits.impl.factory.AbstractRuleUnits;

public abstract class AbstractRuleUnit<T extends RuleUnitData>
implements InternalRuleUnit<T> {
    private final Class<T> ruleUnitDataClass;
    protected final RuleUnits ruleUnits;
    protected Function<ReteEvaluator, ReteEvaluator> evaluatorConfigurator = Function.identity();

    public AbstractRuleUnit(Class<T> ruleUnitDataClass) {
        this(ruleUnitDataClass, AbstractRuleUnits.DummyRuleUnits.INSTANCE);
    }

    public AbstractRuleUnit(Class<T> ruleUnitDataClass, RuleUnits ruleUnits) {
        this.ruleUnitDataClass = ruleUnitDataClass;
        this.ruleUnits = ruleUnits == null ? AbstractRuleUnits.DummyRuleUnits.INSTANCE : ruleUnits;
    }

    protected RuleUnitInstance<T> internalCreateInstance(T data) {
        return this.internalCreateInstance(data, RuleUnitProvider.get().newRuleConfig());
    }

    protected abstract RuleUnitInstance<T> internalCreateInstance(T var1, RuleConfig var2);

    @Override
    public Class<T> getRuleUnitDataClass() {
        return this.ruleUnitDataClass;
    }

    public RuleUnitInstance<T> createInstance(T data) {
        return this.createInstance(data, null, RuleUnitProvider.get().newRuleConfig());
    }

    @Override
    public RuleUnitInstance<T> createInstance(T data, String name) {
        return this.createInstance(data, name, RuleUnitProvider.get().newRuleConfig());
    }

    public RuleUnitInstance<T> createInstance(T data, RuleConfig ruleConfig) {
        return this.createInstance(data, null, ruleConfig);
    }

    @Override
    public RuleUnitInstance<T> createInstance(T data, String name, RuleConfig ruleConfig) {
        RuleUnitInstance<T> instance = this.internalCreateInstance(data, ruleConfig);
        if (name != null) {
            this.ruleUnits.register(name, instance);
        }
        return instance;
    }

    @Override
    public void setEvaluatorConfigurator(Function<ReteEvaluator, ReteEvaluator> evaluatorConfigurator) {
        this.evaluatorConfigurator = evaluatorConfigurator;
    }
}

