/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.dsl.constraints;

import java.io.Serializable;
import java.util.UUID;
import org.drools.model.BetaIndex;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate2;
import org.drools.ruleunits.dsl.constraints.AbstractConstraint;
import org.drools.ruleunits.dsl.util.ClassIntrospectionCache;

public class Beta1Constraint<L, R, V>
extends AbstractConstraint<L, V> {
    private final Variable<R> rightVariable;
    private final Function1<R, V> rightExtractor;

    public Beta1Constraint(Variable<L> leftVariable, String fieldName, Function1<L, V> leftExtractor, Index.ConstraintType constraintType, Variable<R> rightVariable, Function1<R, V> rightExtractor) {
        super(leftVariable, fieldName, leftExtractor, constraintType);
        this.rightVariable = rightVariable;
        this.rightExtractor = rightExtractor;
    }

    @Override
    public void addConstraintToPattern(PatternDSL.PatternDef<L> patternDef) {
        Object exprId;
        BetaIndex betaIndex = null;
        PatternDSL.ReactOn reactOn = null;
        if (this.leftFieldName != null) {
            exprId = "expr:" + this.leftVariable.getType().getCanonicalName() + ":" + this.leftFieldName + ":" + this.constraintType + ":" + this.rightVariable.getType().getCanonicalName();
            betaIndex = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)this.constraintType, (int)ClassIntrospectionCache.getFieldIndex(this.leftVariable.getType(), this.leftFieldName), (Function1)this.leftExtractor, this.rightExtractor);
            reactOn = PatternDSL.reactOn((String[])new String[]{this.leftFieldName});
        } else {
            exprId = UUID.randomUUID().toString();
        }
        patternDef.expr((String)exprId, this.rightVariable, (Predicate2 & Serializable)(l, r) -> this.constraintType.asPredicate().test(this.leftExtractor.apply(l), this.rightExtractor.apply(r)), betaIndex, reactOn);
    }
}

