/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.api;

import java.util.Optional;
import java.util.OptionalInt;
import org.drools.ruleunits.api.conf.ClockType;
import org.drools.ruleunits.api.conf.EventProcessingType;

public class RuleUnitConfig {
    public static final RuleUnitConfig Default = new RuleUnitConfig(EventProcessingType.CLOUD, ClockType.REALTIME, null);
    private final Optional<EventProcessingType> eventProcessingType;
    private final Optional<ClockType> clockType;
    private final OptionalInt sessionPool;

    public RuleUnitConfig(EventProcessingType eventProcessingType, ClockType clockType, Integer sessionPool) {
        this.eventProcessingType = Optional.ofNullable(eventProcessingType);
        this.clockType = Optional.ofNullable(clockType);
        this.sessionPool = sessionPool == null ? OptionalInt.empty() : OptionalInt.of(sessionPool);
    }

    public RuleUnitConfig(Optional<EventProcessingType> eventProcessingType, Optional<ClockType> clockType, OptionalInt sessionPool) {
        this.eventProcessingType = eventProcessingType;
        this.clockType = clockType;
        this.sessionPool = sessionPool;
    }

    public Optional<EventProcessingType> getEventProcessingType() {
        return this.eventProcessingType;
    }

    public EventProcessingType getDefaultedEventProcessingType() {
        return this.getEventProcessingType().orElseGet(Default.getEventProcessingType()::get);
    }

    public Optional<ClockType> getClockType() {
        return this.clockType;
    }

    public ClockType getDefaultedClockType() {
        return this.getClockType().orElseGet(Default.getClockType()::get);
    }

    public OptionalInt getSessionPool() {
        return this.sessionPool;
    }

    public OptionalInt getDefaultedSessionPool() {
        return this.sessionPool.isPresent() ? this.sessionPool : Default.getSessionPool();
    }

    public RuleUnitConfig merged(RuleUnitConfig overrides) {
        if (overrides == null) {
            return this;
        }
        return new RuleUnitConfig(overrides.getEventProcessingType().isPresent() ? overrides.getEventProcessingType() : this.getEventProcessingType(), overrides.getClockType().isPresent() ? overrides.getClockType() : this.getClockType(), overrides.getSessionPool().isPresent() ? overrides.getSessionPool() : this.getSessionPool());
    }
}

