/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.common.IdentityObjectStore;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.infinispan.Cache;
import org.kie.api.runtime.rule.EntryPoint;

public class SimpleReliableObjectStore
extends IdentityObjectStore {
    private final Cache<Long, PropagatedObject> cache;
    private boolean reInitPropagated = false;

    public SimpleReliableObjectStore(Cache<Long, PropagatedObject> cache) {
        this.cache = cache;
    }

    public void addHandle(InternalFactHandle handle, Object object) {
        super.addHandle(handle, object);
        this.putIntoPersistedCache(object, handle.hasMatches());
    }

    public void removeHandle(InternalFactHandle handle) {
        this.removeFromPersistedCache(handle.getObject());
        super.removeHandle(handle);
    }

    List<Object> reInit(InternalWorkingMemory session, EntryPoint ep) {
        this.reInitPropagated = true;
        ArrayList<Object> propagated = new ArrayList<Object>();
        ArrayList<Object> notPropagated = new ArrayList<Object>();
        for (PropagatedObject entry : this.cache.values()) {
            if (entry.propagated) {
                propagated.add(entry.object);
                continue;
            }
            notPropagated.add(entry.object);
        }
        this.cache.clear();
        propagated.forEach(arg_0 -> ((EntryPoint)ep).insert(arg_0));
        session.fireAllRules(match -> false);
        this.reInitPropagated = false;
        return notPropagated;
    }

    void putIntoPersistedCache(Object object, boolean propagated) {
        this.cache.put((Object)((InternalFactHandle)this.fhMap.get(object)).getId(), (Object)new PropagatedObject(object, this.reInitPropagated || propagated));
    }

    void removeFromPersistedCache(Object object) {
        InternalFactHandle fh = (InternalFactHandle)this.fhMap.get(object);
        if (fh != null) {
            this.cache.remove((Object)fh.getId());
        }
    }

    private static class PropagatedObject
    implements Serializable {
        private final Object object;
        private final boolean propagated;

        private PropagatedObject(Object object, boolean propagated) {
            this.object = object;
            this.propagated = propagated;
        }
    }
}

