/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability;

import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.AgendaFactory;
import org.drools.core.common.EntryPointFactory;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.RuleBase;
import org.drools.kiesession.factory.RuntimeComponentFactoryImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.reliability.ReliableAgendaFactory;
import org.drools.reliability.ReliableNamedEntryPointFactory;
import org.drools.reliability.ReliableSessionInitializer;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.PersistedSessionOption;

public class ReliableRuntimeComponentFactoryImpl
extends RuntimeComponentFactoryImpl {
    private static final AtomicLong RELIABLE_SESSIONS_COUNTER = new AtomicLong(0L);
    private final AgendaFactory agendaFactory = ReliableAgendaFactory.getInstance();

    public EntryPointFactory getEntryPointFactory() {
        return new ReliableNamedEntryPointFactory();
    }

    public InternalWorkingMemory createStatefulSession(RuleBase ruleBase, Environment environment, SessionConfiguration sessionConfig, boolean fromPool) {
        if (!sessionConfig.hasPersistedSessionOption()) {
            return super.createStatefulSession(ruleBase, environment, sessionConfig, fromPool);
        }
        InternalKnowledgeBase kbase = (InternalKnowledgeBase)ruleBase;
        if (fromPool || kbase.getSessionPool() == null) {
            InternalWorkingMemory session = this.getWorkingMemoryFactory().createWorkingMemory(RELIABLE_SESSIONS_COUNTER.getAndIncrement(), kbase, sessionConfig, environment);
            return this.internalInitSession(kbase, sessionConfig, session);
        }
        return (InternalWorkingMemory)kbase.getSessionPool().newKieSession((KieSessionConfiguration)sessionConfig);
    }

    private InternalWorkingMemory internalInitSession(InternalKnowledgeBase kbase, SessionConfiguration sessionConfig, InternalWorkingMemory session) {
        if (sessionConfig.isKeepReference()) {
            kbase.addStatefulSession(session);
        }
        return ReliableSessionInitializer.initReliableSession(sessionConfig, session);
    }

    public AgendaFactory getAgendaFactory(SessionConfiguration sessionConfig) {
        if (!sessionConfig.hasPersistedSessionOption() || sessionConfig.getPersistedSessionOption().getStrategy() == PersistedSessionOption.Strategy.STORES_ONLY) {
            return super.getAgendaFactory(sessionConfig);
        }
        return this.agendaFactory;
    }

    static void resetCounter() {
        RELIABLE_SESSIONS_COUNTER.set(0L);
    }

    public int servicePriority() {
        return 1;
    }
}

