/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reliability.infinispan;

import java.util.Optional;
import java.util.Set;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.Storage;
import org.drools.reliability.core.StorageManager;
import org.drools.reliability.infinispan.InfinispanStorage;
import org.drools.reliability.infinispan.InfinispanStorageManager;
import org.drools.util.Config;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStorageManager
implements InfinispanStorageManager {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteStorageManager.class);
    static final RemoteStorageManager INSTANCE = new RemoteStorageManager();
    private RemoteCacheManager remoteCacheManager;
    private InfinispanStorageManager.MarshallerType marshallerType;
    private Optional<ProtoStreamMarshaller> protoMarshaller;

    private RemoteStorageManager() {
    }

    public void initStorageManager() {
        LOG.info("Using Remote Cache Manager");
        String host = Config.getConfig((String)"drools.reliability.storage.infinispan.remote.host");
        String port = Config.getConfig((String)"drools.reliability.storage.infinispan.remote.port");
        String user = Config.getConfig((String)"drools.reliability.storage.infinispan.remote.user");
        String pass = Config.getConfig((String)"drools.reliability.storage.infinispan.remote.pass");
        this.marshallerType = InfinispanStorageManager.getMarshallerType();
        if (host == null || port == null) {
            LOG.info("Remote Cache Manager host '{}' and port '{}' not set. So not creating a default RemoteCacheManager. You will need to set a RemoteCacheManager with setRemoteCacheManager() method.", (Object)host, (Object)port);
            return;
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(host).port(Integer.parseInt(port));
        if (user != null && pass != null) {
            builder.security().authentication().username(user).password(pass);
        }
        this.configureMarshaller(builder);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
    }

    private void configureMarshaller(ConfigurationBuilder builder) {
        if (this.marshallerType == InfinispanStorageManager.MarshallerType.JAVA) {
            builder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialAllowList(InfinispanStorageManager.getAllowedPackages());
        } else if (this.marshallerType == InfinispanStorageManager.MarshallerType.PROTOSTREAM) {
            this.protoMarshaller = Optional.of(new ProtoStreamMarshaller());
            Optional<SerializationContextInitializer> serializationContextInitializer = this.findSerializationContextInitializer();
            if (serializationContextInitializer.isEmpty()) {
                throw new IllegalStateException("ProtoStream serialization context initializer not found");
            }
            builder.marshaller((Marshaller)this.protoMarshaller.get()).addContextInitializer(serializationContextInitializer.get());
        } else {
            throw new IllegalStateException("Unknown MarshallerType: " + this.marshallerType);
        }
    }

    public <K, V> Storage<K, V> internalGetOrCreateStorageForSession(ReteEvaluator reteEvaluator, String cacheName) {
        RemoteCache cache = this.remoteCacheManager.administration().getOrCreateCache(StorageManager.createStorageId((ReteEvaluator)reteEvaluator, (String)cacheName), (String)null);
        return InfinispanStorage.fromCache(cache);
    }

    public <K, V> Storage<K, V> getOrCreateSharedStorage(String cacheName) {
        RemoteCache cache = this.remoteCacheManager.administration().getOrCreateCache("shared_" + cacheName, (String)null);
        return InfinispanStorage.fromCache(cache);
    }

    public void close() {
        this.remoteCacheManager.close();
    }

    public void removeStorage(String storageName) {
        if (this.remoteCacheManager.getCache(storageName) != null) {
            this.remoteCacheManager.administration().removeCache(storageName);
        }
    }

    public void removeStoragesBySessionId(String sessionId) {
        this.remoteCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_" + sessionId + "_")).forEach(this::removeStorage);
    }

    public void removeAllSessionStorages() {
        this.remoteCacheManager.getCacheNames().stream().filter(cacheName -> cacheName.startsWith("session_")).forEach(this::removeStorage);
    }

    public Set<String> getStorageNames() {
        return this.remoteCacheManager.getCacheNames();
    }

    @Override
    public void setRemoteCacheManager(RemoteCacheManager remoteCacheManager) {
        this.remoteCacheManager = remoteCacheManager;
    }

    @Override
    public boolean isProtoStream() {
        return this.marshallerType == InfinispanStorageManager.MarshallerType.PROTOSTREAM;
    }

    public void restart() {
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.stop();
        }
    }

    public void restartWithCleanUp() {
        if (this.remoteCacheManager != null) {
            this.removeAllCache();
            this.remoteCacheManager.stop();
        }
    }

    private void removeAllCache() {
        this.remoteCacheManager.getCacheNames().forEach(this::removeStorage);
    }

    @Override
    public void setEmbeddedCacheManager(DefaultCacheManager cacheManager) {
        throw new UnsupportedOperationException("setEmbeddedCacheManager is not supported in " + this.getClass());
    }

    @Override
    public ConfigurationBuilder provideAdditionalRemoteConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        this.configureMarshaller(builder);
        return builder;
    }

    @Override
    public SerializationContext getSerializationContext() {
        return this.protoMarshaller.get().getSerializationContext();
    }

    public boolean isRemote() {
        return true;
    }
}

